/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util;

import com.taobao.arthas.core.util.StringUtils;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClassLoaderUtils {
    public static Set<ClassLoader> getAllClassLoader(Instrumentation inst) {
        HashSet<ClassLoader> classLoaderSet = new HashSet<ClassLoader>();
        for (Class clazz : inst.getAllLoadedClasses()) {
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader == null) continue;
            classLoaderSet.add(classLoader);
        }
        return classLoaderSet;
    }

    public static ClassLoader getClassLoader(Instrumentation inst, String hashCode) {
        if (hashCode == null || hashCode.isEmpty()) {
            return null;
        }
        for (Class clazz : inst.getAllLoadedClasses()) {
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader == null || !Integer.toHexString(classLoader.hashCode()).equals(hashCode)) continue;
            return classLoader;
        }
        return null;
    }

    public static List<ClassLoader> getClassLoaderByClassName(Instrumentation inst, String classLoaderClassName) {
        if (classLoaderClassName == null || classLoaderClassName.isEmpty()) {
            return null;
        }
        Set<ClassLoader> classLoaderSet = ClassLoaderUtils.getAllClassLoader(inst);
        ArrayList<ClassLoader> matchClassLoaders = new ArrayList<ClassLoader>();
        for (ClassLoader classLoader : classLoaderSet) {
            if (!classLoader.getClass().getName().equals(classLoaderClassName)) continue;
            matchClassLoaders.add(classLoader);
        }
        return matchClassLoaders;
    }

    public static String classLoaderHash(ClassLoader classLoader) {
        int hashCode = 0;
        hashCode = classLoader == null ? System.identityHashCode(classLoader) : classLoader.hashCode();
        if (hashCode <= 0 && (hashCode = System.identityHashCode(classLoader)) < 0) {
            hashCode &= Integer.MAX_VALUE;
        }
        return Integer.toHexString(hashCode);
    }

    public static List<ClassLoader> getClassLoader(Instrumentation inst, String classLoaderClassName, String classLoaderToString) {
        ArrayList<ClassLoader> matchClassLoaders = new ArrayList<ClassLoader>();
        if (StringUtils.isEmpty(classLoaderClassName) && StringUtils.isEmpty(classLoaderToString)) {
            return matchClassLoaders;
        }
        Set<ClassLoader> classLoaderSet = ClassLoaderUtils.getAllClassLoader(inst);
        ArrayList<ClassLoader> matchedByClassLoaderToStr = new ArrayList<ClassLoader>();
        for (ClassLoader classLoader : classLoaderSet) {
            if (!StringUtils.isEmpty(classLoaderClassName) && StringUtils.isEmpty(classLoaderToString)) {
                if (!classLoader.getClass().getName().equals(classLoaderClassName)) continue;
                matchClassLoaders.add(classLoader);
                continue;
            }
            if (!StringUtils.isEmpty(classLoaderToString) && StringUtils.isEmpty(classLoaderClassName)) {
                if (!classLoader.toString().equals(classLoaderToString)) continue;
                matchClassLoaders.add(classLoader);
                continue;
            }
            if (classLoader.getClass().getName().equals(classLoaderClassName)) {
                matchClassLoaders.add(classLoader);
            }
            if (!classLoader.toString().equals(classLoaderToString)) continue;
            matchedByClassLoaderToStr.add(classLoader);
        }
        if (!StringUtils.isEmpty(classLoaderClassName) && !StringUtils.isEmpty(classLoaderToString)) {
            matchClassLoaders.retainAll(matchedByClassLoaderToStr);
        }
        return matchClassLoaders;
    }
}

