/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.common.PidUtils;
import com.taobao.arthas.core.shell.ShellServerOptions;
import com.taobao.arthas.core.util.DateUtils;
import com.taobao.arthas.core.util.IOUtils;
import com.taobao.text.Color;
import com.taobao.text.Decoration;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Map;

public class ArthasBanner {
    private static final String LOGO_LOCATION = "/com/taobao/arthas/core/res/logo.txt";
    private static final String CREDIT_LOCATION = "/com/taobao/arthas/core/res/thanks.txt";
    private static final String VERSION_LOCATION = "/com/taobao/arthas/core/res/version";
    private static final String WIKI = "https://arthas.aliyun.com/doc";
    private static final String TUTORIALS = "https://arthas.aliyun.com/doc/arthas-tutorials.html";
    private static final String ARTHAS_LATEST_VERSIONS_URL = "https://arthas.aliyun.com/api/latest_version";
    private static final int CONNECTION_TIMEOUT = 1000;
    private static final int READ_TIMEOUT = 1000;
    private static String LOGO = "Welcome to Arthas";
    private static String VERSION = "unknown";
    private static String THANKS = "";
    private static final Logger logger = LoggerFactory.getLogger(ArthasBanner.class);

    public static String wiki() {
        return WIKI;
    }

    public static String tutorials() {
        return TUTORIALS;
    }

    public static String credit() {
        return THANKS;
    }

    public static String version() {
        return VERSION;
    }

    public static String logo() {
        return LOGO;
    }

    public static String plainTextLogo() {
        return RenderUtil.ansiToPlainText((String)LOGO);
    }

    public static String welcome() {
        return ArthasBanner.welcome(Collections.<String, String>emptyMap());
    }

    public static String welcome(Map<String, String> infos) {
        logger.info("Current arthas version: {}, recommend latest version: {}", (Object)ArthasBanner.version(), (Object)ArthasBanner.latestVersion());
        TableElement table = new TableElement().rightCellPadding(1).row(new String[]{"wiki", ArthasBanner.wiki()}).row(new String[]{"tutorials", ArthasBanner.tutorials()}).row(new String[]{"version", ArthasBanner.version()}).row(new String[]{"main_class", PidUtils.mainClass()}).row(new String[]{"pid", PidUtils.currentPid()}).row(new String[]{"time", DateUtils.getCurrentDate()});
        for (Map.Entry<String, String> entry : infos.entrySet()) {
            table.row(new String[]{entry.getKey(), entry.getValue()});
        }
        return ArthasBanner.logo() + "\n" + RenderUtil.render((Element)table);
    }

    static String latestVersion() {
        try {
            URLConnection urlConnection = ArthasBanner.openURLConnection(ARTHAS_LATEST_VERSIONS_URL);
            InputStream inputStream = urlConnection.getInputStream();
            return com.taobao.arthas.common.IOUtils.toString((InputStream)inputStream).trim();
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    private static URLConnection openURLConnection(String url) throws MalformedURLException, IOException {
        URLConnection connection = new URL(url).openConnection();
        if (connection instanceof HttpURLConnection) {
            connection.setConnectTimeout(1000);
            connection.setReadTimeout(1000);
            int status = ((HttpURLConnection)connection).getResponseCode();
            if (status != 200 && (status == 302 || status == 301 || status == 303)) {
                String newUrl = connection.getHeaderField("Location");
                logger.debug("Try to open url: {}, redirect to: {}", (Object)url, (Object)newUrl);
                return ArthasBanner.openURLConnection(newUrl);
            }
        }
        return connection;
    }

    static {
        try {
            String logoText = IOUtils.toString(ShellServerOptions.class.getResourceAsStream(LOGO_LOCATION));
            THANKS = IOUtils.toString(ShellServerOptions.class.getResourceAsStream(CREDIT_LOCATION));
            InputStream versionInputStream = ShellServerOptions.class.getResourceAsStream(VERSION_LOCATION);
            if (versionInputStream != null) {
                VERSION = IOUtils.toString(versionInputStream).trim();
            } else {
                String implementationVersion = ArthasBanner.class.getPackage().getImplementationVersion();
                if (implementationVersion != null) {
                    VERSION = implementationVersion;
                }
            }
            StringBuilder sb = new StringBuilder();
            String[] LOGOS = new String[6];
            int i = 0;
            int j = 0;
            for (String line : logoText.split("\n")) {
                sb.append(line);
                sb.append("\n");
                if (i++ != 4) continue;
                LOGOS[j++] = sb.toString();
                i = 0;
                sb.setLength(0);
            }
            TableElement logoTable = new TableElement();
            logoTable.row(new Element[]{Element.label((String)LOGOS[0]).style(Decoration.bold.fg(Color.red)), Element.label((String)LOGOS[1]).style(Decoration.bold.fg(Color.yellow)), Element.label((String)LOGOS[2]).style(Decoration.bold.fg(Color.cyan)), Element.label((String)LOGOS[3]).style(Decoration.bold.fg(Color.magenta)), Element.label((String)LOGOS[4]).style(Decoration.bold.fg(Color.green)), Element.label((String)LOGOS[5]).style(Decoration.bold.fg(Color.blue))});
            LOGO = RenderUtil.render((Element)logoTable);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

