/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.view;

import com.taobao.arthas.core.command.model.ClassVO;
import com.taobao.arthas.core.command.model.JadModel;
import com.taobao.arthas.core.command.view.ClassLoaderView;
import com.taobao.arthas.core.command.view.ResultView;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.ClassUtils;
import com.taobao.arthas.core.util.TypeRenderUtils;
import com.taobao.text.Color;
import com.taobao.text.Decoration;
import com.taobao.text.lang.LangRenderUtil;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.LabelElement;
import com.taobao.text.util.RenderUtil;

public class JadView
extends ResultView<JadModel> {
    @Override
    public void draw(CommandProcess process, JadModel result) {
        if (result.getMatchedClassLoaders() != null) {
            process.write("Matched classloaders: \n");
            ClassLoaderView.drawClassLoaders(process, result.getMatchedClassLoaders(), false);
            process.write("\n");
            return;
        }
        int width = process.width();
        if (result.getMatchedClasses() != null) {
            Element table = ClassUtils.renderMatchedClasses(result.getMatchedClasses());
            process.write(RenderUtil.render((Element)table, (int)width)).write("\n");
        } else {
            ClassVO classInfo = result.getClassInfo();
            if (classInfo != null) {
                process.write("\n");
                process.write(RenderUtil.render((Element)new LabelElement("ClassLoader: ").style(Decoration.bold.fg(Color.red)), (int)width));
                process.write(RenderUtil.render((Element)TypeRenderUtils.drawClassLoader(classInfo), (int)width) + "\n");
            }
            if (result.getLocation() != null) {
                process.write(RenderUtil.render((Element)new LabelElement("Location: ").style(Decoration.bold.fg(Color.red)), (int)width));
                process.write(RenderUtil.render((Element)new LabelElement(result.getLocation()).style(Decoration.bold.fg(Color.blue)), (int)width) + "\n");
            }
            process.write(LangRenderUtil.render((String)result.getSource()) + "\n");
            process.write("");
        }
    }
}

