/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.advisor.Advice;
import com.taobao.arthas.core.advisor.AdviceListenerAdapter;
import com.taobao.arthas.core.advisor.ArthasMethod;
import com.taobao.arthas.core.command.express.ExpressException;
import com.taobao.arthas.core.command.model.MonitorModel;
import com.taobao.arthas.core.command.monitor200.MonitorCommand;
import com.taobao.arthas.core.command.monitor200.MonitorData;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.ArthasCheckUtils;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.util.ThreadLocalWatch;
import java.util.ArrayList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

class MonitorAdviceListener
extends AdviceListenerAdapter {
    private Timer timer;
    private static final Logger logger = LoggerFactory.getLogger(MonitorAdviceListener.class);
    private ConcurrentHashMap<Key, AtomicReference<MonitorData>> monitorData = new ConcurrentHashMap();
    private final ThreadLocalWatch threadLocalWatch = new ThreadLocalWatch();
    private final ThreadLocal<Boolean> conditionResult = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return true;
        }
    };
    private MonitorCommand command;
    private CommandProcess process;

    MonitorAdviceListener(MonitorCommand command, CommandProcess process, boolean verbose) {
        this.command = command;
        this.process = process;
        super.setVerbose(verbose);
    }

    @Override
    public synchronized void create() {
        if (this.timer == null) {
            this.timer = new Timer("Timer-for-arthas-monitor-" + this.process.session().getSessionId(), true);
            this.timer.scheduleAtFixedRate((TimerTask)new MonitorTimer(this.monitorData, this.process, this.command.getNumberOfLimit()), 0L, (long)this.command.getCycle() * 1000L);
        }
    }

    @Override
    public synchronized void destroy() {
        if (null != this.timer) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    @Override
    public void before(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args) throws Throwable {
        this.threadLocalWatch.start();
        if (!StringUtils.isEmpty(this.command.getConditionExpress()) && this.command.isBefore()) {
            Advice advice = Advice.newForBefore(loader, clazz, method, target, args);
            long cost = this.threadLocalWatch.cost();
            this.conditionResult.set(this.isConditionMet(this.command.getConditionExpress(), advice, cost));
            this.threadLocalWatch.start();
        }
    }

    @Override
    public void afterReturning(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args, Object returnObject) throws Throwable {
        this.finishing(clazz, method, false, Advice.newForAfterReturning(loader, clazz, method, target, args, returnObject));
    }

    @Override
    public void afterThrowing(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args, Throwable throwable) {
        this.finishing(clazz, method, true, Advice.newForAfterThrowing(loader, clazz, method, target, args, throwable));
    }

    private void finishing(Class<?> clazz, ArthasMethod method, boolean isThrowing, Advice advice) {
        MonitorData nData;
        MonitorData oData;
        AtomicReference<MonitorData> value;
        double cost = this.threadLocalWatch.costInMillis();
        if (this.command.isBefore()) {
            if (!this.conditionResult.get().booleanValue()) {
                return;
            }
        } else {
            try {
                if (!this.isConditionMet(this.command.getConditionExpress(), advice, cost)) {
                    return;
                }
            }
            catch (ExpressException e) {
                logger.warn("monitor execute condition-express failed.", (Throwable)e);
                return;
            }
        }
        Key key = new Key(clazz.getName(), method.getName());
        while (null == (value = this.monitorData.get(key))) {
            this.monitorData.putIfAbsent(key, new AtomicReference<MonitorData>(new MonitorData()));
        }
        do {
            oData = value.get();
            nData = new MonitorData();
            nData.setCost(oData.getCost() + cost);
            if (isThrowing) {
                nData.setFailed(oData.getFailed() + 1);
                nData.setSuccess(oData.getSuccess());
            } else {
                nData.setFailed(oData.getFailed());
                nData.setSuccess(oData.getSuccess() + 1);
            }
            nData.setTotal(oData.getTotal() + 1);
        } while (!value.compareAndSet(oData, nData));
    }

    private static class Key {
        private final String className;
        private final String methodName;

        Key(String className, String behaviorName) {
            this.className = className;
            this.methodName = behaviorName;
        }

        public String getClassName() {
            return this.className;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public int hashCode() {
            return this.className.hashCode() + this.methodName.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key okey = (Key)obj;
            return ArthasCheckUtils.isEquals(okey.className, this.className) && ArthasCheckUtils.isEquals(okey.methodName, this.methodName);
        }
    }

    private class MonitorTimer
    extends TimerTask {
        private Map<Key, AtomicReference<MonitorData>> monitorData;
        private CommandProcess process;
        private int limit;

        MonitorTimer(Map<Key, AtomicReference<MonitorData>> monitorData, CommandProcess process, int limit) {
            this.monitorData = monitorData;
            this.process = process;
            this.limit = limit;
        }

        @Override
        public void run() {
            if (this.monitorData.isEmpty()) {
                return;
            }
            if (this.process.times().getAndIncrement() >= this.limit) {
                this.cancel();
                MonitorAdviceListener.this.abortProcess(this.process, this.limit);
                return;
            }
            ArrayList<MonitorData> monitorDataList = new ArrayList<MonitorData>(this.monitorData.size());
            for (Map.Entry<Key, AtomicReference<MonitorData>> entry : this.monitorData.entrySet()) {
                MonitorData data;
                AtomicReference<MonitorData> value = entry.getValue();
                while (!value.compareAndSet(data = value.get(), new MonitorData())) {
                }
                if (null == data) continue;
                data.setClassName(entry.getKey().getClassName());
                data.setMethodName(entry.getKey().getMethodName());
                monitorDataList.add(data);
            }
            this.process.appendResult(new MonitorModel(monitorDataList));
        }
    }
}

