/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.taobao.arthas.core.command.model.TimeFragmentVO;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.view.ObjectView;
import com.taobao.text.Decoration;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.LabelElement;
import com.taobao.text.ui.TableElement;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class TimeTunnelTable {
    private static final int[] TABLE_COL_WIDTH = new int[]{8, 20, 10, 8, 8, 15, 30, 30};
    private static final String[] TABLE_COL_TITLE = new String[]{"INDEX", "TIMESTAMP", "COST(ms)", "IS-RET", "IS-EXP", "OBJECT", "CLASS", "METHOD"};

    static TableElement createTable() {
        return new TableElement(TABLE_COL_WIDTH).leftCellPadding(1).rightCellPadding(1);
    }

    public static TableElement createDefaultTable() {
        return new TableElement().leftCellPadding(1).rightCellPadding(1);
    }

    static TableElement fillTableHeader(TableElement table) {
        LabelElement[] headers = new LabelElement[TABLE_COL_TITLE.length];
        for (int i = 0; i < TABLE_COL_TITLE.length; ++i) {
            headers[i] = Element.label((String)TABLE_COL_TITLE[i]).style(Decoration.bold.bold());
        }
        table.row(true, (Element[])headers);
        return table;
    }

    public static Element drawTimeTunnelTable(List<TimeFragmentVO> timeFragmentList, boolean withHeader) {
        TableElement table = TimeTunnelTable.createTable();
        if (withHeader) {
            TimeTunnelTable.fillTableHeader(table);
        }
        for (TimeFragmentVO tf : timeFragmentList) {
            TimeTunnelTable.fillTableRow(table, tf);
        }
        return table;
    }

    static TableElement fillTableRow(TableElement table, TimeFragmentVO tf) {
        return table.row(new String[]{"" + tf.getIndex(), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(tf.getTimestamp()), "" + tf.getCost(), "" + tf.isReturn(), "" + tf.isThrow(), tf.getObject(), StringUtils.substringAfterLast("." + tf.getClassName(), "."), tf.getMethodName()});
    }

    public static void drawTimeTunnel(TableElement table, TimeFragmentVO tf) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        table.row(new String[]{"INDEX", "" + tf.getIndex()}).row(new String[]{"GMT-CREATE", sdf.format(tf.getTimestamp())}).row(new String[]{"COST(ms)", "" + tf.getCost()}).row(new String[]{"OBJECT", tf.getObject()}).row(new String[]{"CLASS", tf.getClassName()}).row(new String[]{"METHOD", tf.getMethodName()}).row(new String[]{"IS-RETURN", "" + tf.isReturn()}).row(new String[]{"IS-EXCEPTION", "" + tf.isThrow()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawThrowException(TableElement table, TimeFragmentVO tf, boolean isNeedExpand, Integer expandLevel) {
        if (tf.isThrow()) {
            Throwable throwable = tf.getThrowExp();
            if (isNeedExpand) {
                table.row(new String[]{"THROW-EXCEPTION", new ObjectView(throwable, expandLevel).draw()});
            } else {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                try {
                    throwable.printStackTrace(printWriter);
                    table.row(new String[]{"THROW-EXCEPTION", stringWriter.toString()});
                }
                finally {
                    printWriter.close();
                }
            }
        }
    }

    public static void drawReturnObj(TableElement table, TimeFragmentVO tf, boolean isNeedExpand, Integer expandLevel, Integer sizeLimit) {
        if (tf.isReturn()) {
            if (isNeedExpand) {
                table.row(new String[]{"RETURN-OBJ", new ObjectView(tf.getReturnObj(), expandLevel, sizeLimit).draw()});
            } else {
                table.row(new String[]{"RETURN-OBJ", "" + StringUtils.objectToString(tf.getReturnObj())});
            }
        }
    }

    public static void drawParameters(TableElement table, Object[] params, boolean isNeedExpand, Integer expandLevel) {
        if (params != null) {
            int paramIndex = 0;
            for (Object param : params) {
                if (isNeedExpand) {
                    table.row(new String[]{"PARAMETERS[" + paramIndex++ + "]", new ObjectView(param, expandLevel).draw()});
                    continue;
                }
                table.row(new String[]{"PARAMETERS[" + paramIndex++ + "]", "" + StringUtils.objectToString(param)});
            }
        }
    }

    public static void drawWatchTableHeader(TableElement table) {
        table.row(true, new Element[]{Element.label((String)"INDEX").style(Decoration.bold.bold()), Element.label((String)"SEARCH-RESULT").style(Decoration.bold.bold())});
    }

    public static void drawWatchResults(TableElement table, Map<Integer, Object> watchResults, boolean isNeedExpand, Integer expandLevel, Integer sizeLimit) {
        for (Map.Entry<Integer, Object> entry : watchResults.entrySet()) {
            Object value = entry.getValue();
            table.row(new String[]{"" + entry.getKey(), "" + (isNeedExpand ? new ObjectView(value, expandLevel, sizeLimit).draw() : StringUtils.objectToString(value))});
        }
    }

    public static TableElement drawPlayHeader(String className, String methodName, String objectAddress, int index, TableElement table) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return table.row(new String[]{"RE-INDEX", "" + index}).row(new String[]{"GMT-REPLAY", sdf.format(new Date())}).row(new String[]{"OBJECT", objectAddress}).row(new String[]{"CLASS", className}).row(new String[]{"METHOD", methodName});
    }

    public static void drawPlayResult(TableElement table, Object returnObj, boolean isNeedExpand, int expandLevel, int sizeLimit, double cost) {
        table.row(new String[]{"IS-RETURN", "true"});
        table.row(new String[]{"IS-EXCEPTION", "false"});
        table.row(new String[]{"COST(ms)", "" + cost});
        if (isNeedExpand) {
            table.row(new String[]{"RETURN-OBJ", new ObjectView(returnObj, expandLevel, sizeLimit).draw()});
        } else {
            table.row(new String[]{"RETURN-OBJ", "" + StringUtils.objectToString(returnObj)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawPlayException(TableElement table, Throwable t, boolean isNeedExpand, int expandLevel) {
        table.row(new String[]{"IS-RETURN", "false"});
        table.row(new String[]{"IS-EXCEPTION", "true"});
        Throwable cause = t instanceof InvocationTargetException ? t.getCause() : t;
        if (isNeedExpand) {
            table.row(new String[]{"THROW-EXCEPTION", new ObjectView(cause, expandLevel).draw()});
        } else {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            try {
                cause.printStackTrace(printWriter);
                table.row(new String[]{"THROW-EXCEPTION", stringWriter.toString()});
            }
            finally {
                printWriter.close();
            }
        }
    }
}

