/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.system.impl;

import com.taobao.arthas.core.command.BuiltinCommandPack;
import com.taobao.arthas.core.shell.cli.CliToken;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.command.Command;
import com.taobao.arthas.core.shell.command.CommandResolver;
import com.taobao.arthas.core.shell.system.impl.CommandCompletion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class InternalCommandManager {
    private final List<CommandResolver> resolvers;

    public InternalCommandManager(CommandResolver ... resolvers) {
        this.resolvers = Arrays.asList(resolvers);
    }

    public InternalCommandManager(List<CommandResolver> resolvers) {
        this.resolvers = resolvers;
    }

    public List<CommandResolver> getResolvers() {
        return this.resolvers;
    }

    public Command getCommand(String commandName) {
        Command command = null;
        for (CommandResolver resolver : this.resolvers) {
            if (resolver instanceof BuiltinCommandPack && (command = InternalCommandManager.getCommand(resolver, commandName)) != null) break;
        }
        return command;
    }

    public void complete(Completion completion) {
        List<CliToken> lineTokens = completion.lineTokens();
        int index = InternalCommandManager.findLastPipe(lineTokens);
        LinkedList<CliToken> tokens = new LinkedList<CliToken>(lineTokens.subList(index + 1, lineTokens.size()));
        while (tokens.size() > 0 && tokens.getFirst().isBlank()) {
            tokens.removeFirst();
        }
        if (tokens.size() > 1) {
            this.completeSingleCommand(completion, tokens);
        } else {
            this.completeCommands(completion, tokens);
        }
    }

    private void completeCommands(Completion completion, LinkedList<CliToken> tokens) {
        String prefix = tokens.size() > 0 ? tokens.getFirst().value() : "";
        LinkedList<String> names = new LinkedList<String>();
        for (CommandResolver resolver : this.resolvers) {
            for (Command command : resolver.commands()) {
                boolean hidden;
                String name = command.name();
                boolean bl = hidden = command.cli() != null && command.cli().isHidden();
                if (!name.startsWith(prefix) || names.contains(name) || hidden) continue;
                names.add(name);
            }
        }
        if (names.size() == 1) {
            completion.complete(((String)names.get(0)).substring(prefix.length()), true);
        } else {
            String commonPrefix = CompletionUtils.findLongestCommonPrefix(names);
            if (commonPrefix.length() > prefix.length()) {
                completion.complete(commonPrefix.substring(prefix.length()), false);
            } else {
                completion.complete(names);
            }
        }
    }

    private void completeSingleCommand(Completion completion, LinkedList<CliToken> tokens) {
        ListIterator it = tokens.listIterator();
        while (it.hasNext()) {
            CliToken ct = (CliToken)it.next();
            it.remove();
            if (!ct.isText()) continue;
            ArrayList<CliToken> newTokens = new ArrayList<CliToken>();
            while (it.hasNext()) {
                newTokens.add((CliToken)it.next());
            }
            StringBuilder tmp = new StringBuilder();
            for (CliToken token : newTokens) {
                tmp.append(token.raw());
            }
            String line = tmp.toString();
            for (CommandResolver resolver : this.resolvers) {
                Command command = InternalCommandManager.getCommand(resolver, ct.value());
                if (command == null) continue;
                command.complete(new CommandCompletion(completion, line, newTokens));
                return;
            }
            completion.complete(Collections.<String>emptyList());
        }
    }

    private static Command getCommand(CommandResolver commandResolver, String name) {
        List<Command> commands = commandResolver.commands();
        if (commands == null || commands.isEmpty()) {
            return null;
        }
        for (Command command : commands) {
            if (!name.equals(command.name())) continue;
            return command;
        }
        return null;
    }

    private static int findLastPipe(List<CliToken> lineTokens) {
        int index = -1;
        for (int i = 0; i < lineTokens.size(); ++i) {
            if (!"|".equals(lineTokens.get(i).value())) continue;
            index = i;
        }
        return index;
    }
}

