/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util;

import com.taobao.arthas.common.IOUtils;
import com.taobao.arthas.core.util.StringUtils;
import io.termd.core.util.Helper;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class FileUtils {
    private static final int[] AUTH_CODEPOINTS = Helper.toCodePoints((String)"auth");

    public static void writeByteArrayToFile(File file, byte[] data) throws IOException {
        FileUtils.writeByteArrayToFile(file, data, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeByteArrayToFile(File file, byte[] data, boolean append) throws IOException {
        FileOutputStream out = null;
        try {
            out = FileUtils.openOutputStream(file, append);
            ((OutputStream)out).write(data);
            ((OutputStream)out).close();
        }
        finally {
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static FileOutputStream openOutputStream(File file, boolean append) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("File '" + file + "' cannot be written to");
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null && !parent.mkdirs() && !parent.isDirectory()) {
                throw new IOException("Directory '" + parent + "' could not be created");
            }
        }
        return new FileOutputStream(file, append);
    }

    private static boolean isAuthCommand(String command) {
        return command != null && command.trim().startsWith("auth");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveCommandHistory(List<int[]> history, File file) {
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(FileUtils.openOutputStream(file, false));
            for (int[] command : history) {
                String commandStr = Helper.fromCodePoints((int[])command);
                if (FileUtils.isAuthCommand(commandStr)) {
                    command = AUTH_CODEPOINTS;
                }
                for (int i : command) {
                    ((OutputStream)out).write(i);
                }
                ((OutputStream)out).write(10);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<int[]> loadCommandHistory(File file) {
        BufferedReader br = null;
        ArrayList<int[]> history = new ArrayList<int[]>();
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            while ((line = br.readLine()) != null) {
                history.add(Helper.toCodePoints((String)line));
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
        return history;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveCommandHistoryString(List<String> history, File file) {
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(FileUtils.openOutputStream(file, false));
            for (String command : history) {
                if (StringUtils.isBlank(command)) continue;
                if (FileUtils.isAuthCommand(command)) {
                    command = "auth";
                }
                ((OutputStream)out).write(command.getBytes("utf-8"));
                ((OutputStream)out).write(10);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> loadCommandHistoryString(File file) {
        BufferedReader br = null;
        ArrayList<String> history = new ArrayList<String>();
        try {
            String line;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));
            while ((line = br.readLine()) != null) {
                if (StringUtils.isBlank(line)) continue;
                history.add(line);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
        return history;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(File file, Charset encoding) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        try {
            int read;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, encoding));
            StringBuilder builder = new StringBuilder();
            char[] buffer = new char[8192];
            while ((read = ((Reader)reader).read(buffer, 0, buffer.length)) > 0) {
                builder.append(buffer, 0, read);
            }
            String string = builder.toString();
            return string;
        }
        finally {
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readProperties(String file) throws IOException {
        Properties properties;
        Properties properties2 = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            properties2.load(in);
            properties = properties2;
        }
        catch (Throwable throwable) {
            IOUtils.close(in);
            throw throwable;
        }
        IOUtils.close((InputStream)in);
        return properties;
    }
}

