/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.term.impl.http;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.common.IOUtils;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelProgressiveFuture;
import io.netty.channel.ChannelProgressiveFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedFile;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class DirectoryBrowser {
    public static final String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String HTTP_DATE_GMT_TIMEZONE = "GMT";
    public static final long MIN_NETTY_DIRECT_SEND_SIZE = 0x800000L;
    private static final Logger logger = LoggerFactory.getLogger(DirectoryBrowser.class);
    private static String pageHeader = "<!DOCTYPE html>\n<html>\n\n<head>\n    <title>Arthas Resouces: %s</title>\n    <meta charset=\"utf-8\" name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <style>\nbody {\n    background: #fff;\n}\n    </style>\n</head>\n\n<body>\n    <header>\n        <h1>%s</h1>\n    </header>\n    <hr/>\n    <main>\n        <pre id=\"contents\">\n";
    private static String pageFooter = "       </pre>\n    </main>\n    <hr/>\n</body>\n\n</html>";
    private static String linePart1Str = "<a href=\"%s\" title=\"%s\">";
    private static String linePart2Str = "%-60s";

    static String renderDir(File dir) {
        Object[] listFiles = dir.listFiles();
        StringBuilder sb = new StringBuilder(8192);
        String dirName = dir.getName() + "/";
        sb.append(String.format(pageHeader, dirName, dirName));
        sb.append("<a href=\"../\" title=\"../\">../</a>\n");
        if (listFiles != null) {
            String modifyStr;
            SimpleDateFormat simpleDateFormat;
            String part2Format;
            String linePart2;
            String part1Format;
            String name;
            Arrays.sort(listFiles);
            for (Object f : listFiles) {
                if (!((File)f).isDirectory()) continue;
                name = ((File)f).getName() + "/";
                part1Format = String.format(linePart1Str, name, name, name);
                sb.append(part1Format);
                linePart2 = name + "</a>";
                part2Format = String.format(linePart2Str, linePart2);
                sb.append(part2Format);
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                modifyStr = simpleDateFormat.format(new Date(((File)f).lastModified()));
                sb.append(modifyStr);
                sb.append("         -      ").append("\r\n");
            }
            for (Object f : listFiles) {
                if (!((File)f).isFile()) continue;
                name = ((File)f).getName();
                part1Format = String.format(linePart1Str, name, name, name);
                sb.append(part1Format);
                linePart2 = name + "</a>";
                part2Format = String.format(linePart2Str, linePart2);
                sb.append(part2Format);
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                modifyStr = simpleDateFormat.format(new Date(((File)f).lastModified()));
                sb.append(modifyStr);
                String sizeStr = String.format("%10d      ", ((File)f).length());
                sb.append(sizeStr).append("\r\n");
            }
        }
        sb.append(pageFooter);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DefaultFullHttpResponse directView(File dir, String path, FullHttpRequest request, ChannelHandlerContext ctx) throws IOException {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        File file = new File(dir.getParent(), path);
        HttpVersion version = request.protocolVersion();
        if (DirectoryBrowser.isSubFile(dir, file)) {
            DefaultFullHttpResponse fullResp = new DefaultFullHttpResponse(version, HttpResponseStatus.OK);
            if (file.isDirectory()) {
                if (!path.endsWith("/")) {
                    fullResp.setStatus(HttpResponseStatus.FOUND).headers().set((CharSequence)HttpHeaderNames.LOCATION, (Object)("/" + path + "/"));
                }
                String renderResult = DirectoryBrowser.renderDir(file);
                fullResp.content().writeBytes(renderResult.getBytes("utf-8"));
                fullResp.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html; charset=utf-8");
                ctx.write((Object)fullResp);
                ChannelFuture future = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
                future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                return fullResp;
            }
            logger.info("get file now. file:" + file.getPath());
            if (file.isHidden() || !file.exists() || file.isDirectory() || !file.isFile()) {
                return null;
            }
            RandomAccessFile raf = null;
            try {
                ChannelFuture lastContentFuture;
                ChannelFuture sendFileFuture;
                raf = new RandomAccessFile(file, "r");
                long fileLength = raf.length();
                if (fileLength < 0x800000L) {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    try {
                        byte[] content = IOUtils.getBytes((InputStream)fileInputStream);
                        fullResp.content().writeBytes(content);
                        HttpUtil.setContentLength((HttpMessage)fullResp, (long)fullResp.content().readableBytes());
                    }
                    finally {
                        IOUtils.close((InputStream)fileInputStream);
                    }
                    ctx.write((Object)fullResp);
                    ChannelFuture future = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
                    future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    DefaultFullHttpResponse defaultFullHttpResponse = fullResp;
                    return defaultFullHttpResponse;
                }
                logger.info("file {} size bigger than {}, send by future.", (Object)file.getName(), (Object)0x800000L);
                DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
                HttpUtil.setContentLength((HttpMessage)response, (long)fileLength);
                DirectoryBrowser.setContentTypeHeader((HttpResponse)response, file);
                DirectoryBrowser.setDateAndCacheHeaders((HttpResponse)response, file);
                if (HttpUtil.isKeepAlive((HttpMessage)request)) {
                    response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
                }
                ctx.write((Object)response);
                if (ctx.pipeline().get(SslHandler.class) == null) {
                    sendFileFuture = ctx.write((Object)new DefaultFileRegion(raf.getChannel(), 0L, fileLength), (ChannelPromise)ctx.newProgressivePromise());
                    lastContentFuture = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
                } else {
                    lastContentFuture = sendFileFuture = ctx.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)new ChunkedFile(raf, 0L, fileLength, 8192)), (ChannelPromise)ctx.newProgressivePromise());
                }
                sendFileFuture.addListener((GenericFutureListener)new ChannelProgressiveFutureListener(){

                    public void operationProgressed(ChannelProgressiveFuture future, long progress, long total) {
                        if (total < 0L) {
                            logger.info(future.channel() + " Transfer progress: " + progress);
                        } else {
                            logger.info(future.channel() + " Transfer progress: " + progress + " / " + total);
                        }
                    }

                    public void operationComplete(ChannelProgressiveFuture future) {
                        logger.info(future.channel() + " Transfer complete.");
                    }
                });
                if (!HttpUtil.isKeepAlive((HttpMessage)request)) {
                    lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                }
            }
            catch (Throwable e) {
                logger.error("view file error, dir: {}, path: {}", new Object[]{dir, path, e});
                DefaultFullHttpResponse defaultFullHttpResponse = null;
                return defaultFullHttpResponse;
            }
            finally {
                if (raf != null) {
                    IOUtils.close((Closeable)raf);
                }
            }
            return fullResp;
        }
        return null;
    }

    private static void setDateAndCacheHeaders(HttpResponse response, File fileToCache) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(TimeZone.getTimeZone(HTTP_DATE_GMT_TIMEZONE));
        GregorianCalendar time = new GregorianCalendar();
        response.headers().set((CharSequence)HttpHeaderNames.DATE, (Object)dateFormatter.format(time.getTime()));
        ((Calendar)time).add(13, 3600);
        response.headers().set((CharSequence)HttpHeaderNames.EXPIRES, (Object)dateFormatter.format(time.getTime()));
        response.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"private, max-age=3600");
        response.headers().set((CharSequence)HttpHeaderNames.LAST_MODIFIED, (Object)dateFormatter.format(new Date(fileToCache.lastModified())));
    }

    private static void setContentTypeHeader(HttpResponse response, File file) {
        String contentType = "application/octet-stream";
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
    }

    public static boolean isSubFile(File parent, File child) throws IOException {
        String childPath;
        String parentPath = parent.getCanonicalPath();
        return parentPath.equals(childPath = child.getCanonicalPath()) || childPath.startsWith(parent.getCanonicalPath() + File.separator);
    }
}

