/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.view;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.command.model.ResultModel;
import com.taobao.arthas.core.command.view.Base64View;
import com.taobao.arthas.core.command.view.CatView;
import com.taobao.arthas.core.command.view.ClassLoaderView;
import com.taobao.arthas.core.command.view.DashboardView;
import com.taobao.arthas.core.command.view.DumpClassView;
import com.taobao.arthas.core.command.view.EchoView;
import com.taobao.arthas.core.command.view.EnhancerView;
import com.taobao.arthas.core.command.view.GetStaticView;
import com.taobao.arthas.core.command.view.HelpView;
import com.taobao.arthas.core.command.view.JadView;
import com.taobao.arthas.core.command.view.JvmView;
import com.taobao.arthas.core.command.view.LoggerView;
import com.taobao.arthas.core.command.view.MBeanView;
import com.taobao.arthas.core.command.view.MemoryCompilerView;
import com.taobao.arthas.core.command.view.MessageView;
import com.taobao.arthas.core.command.view.MonitorView;
import com.taobao.arthas.core.command.view.OgnlView;
import com.taobao.arthas.core.command.view.OptionsView;
import com.taobao.arthas.core.command.view.PerfCounterView;
import com.taobao.arthas.core.command.view.ProfilerView;
import com.taobao.arthas.core.command.view.PwdView;
import com.taobao.arthas.core.command.view.RedefineView;
import com.taobao.arthas.core.command.view.ResetView;
import com.taobao.arthas.core.command.view.ResultView;
import com.taobao.arthas.core.command.view.RetransformView;
import com.taobao.arthas.core.command.view.RowAffectView;
import com.taobao.arthas.core.command.view.SearchClassView;
import com.taobao.arthas.core.command.view.SearchMethodView;
import com.taobao.arthas.core.command.view.SessionView;
import com.taobao.arthas.core.command.view.ShutdownView;
import com.taobao.arthas.core.command.view.StackView;
import com.taobao.arthas.core.command.view.StatusView;
import com.taobao.arthas.core.command.view.SystemEnvView;
import com.taobao.arthas.core.command.view.SystemPropertyView;
import com.taobao.arthas.core.command.view.ThreadView;
import com.taobao.arthas.core.command.view.TimeTunnelView;
import com.taobao.arthas.core.command.view.TraceView;
import com.taobao.arthas.core.command.view.VMOptionView;
import com.taobao.arthas.core.command.view.VersionView;
import com.taobao.arthas.core.command.view.WatchView;
import com.taobao.arthas.core.shell.command.CommandProcess;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ResultViewResolver {
    private static final Logger logger = LoggerFactory.getLogger(ResultViewResolver.class);
    private Map<Class, ResultView> resultViewMap = new ConcurrentHashMap<Class, ResultView>();

    public ResultViewResolver() {
        this.initResultViews();
    }

    private void initResultViews() {
        try {
            this.registerView(RowAffectView.class);
            this.registerView(StatusView.class);
            this.registerView(VersionView.class);
            this.registerView(MessageView.class);
            this.registerView(HelpView.class);
            this.registerView(EchoView.class);
            this.registerView(CatView.class);
            this.registerView(Base64View.class);
            this.registerView(OptionsView.class);
            this.registerView(SystemPropertyView.class);
            this.registerView(SystemEnvView.class);
            this.registerView(PwdView.class);
            this.registerView(VMOptionView.class);
            this.registerView(SessionView.class);
            this.registerView(ResetView.class);
            this.registerView(ShutdownView.class);
            this.registerView(ClassLoaderView.class);
            this.registerView(DumpClassView.class);
            this.registerView(GetStaticView.class);
            this.registerView(JadView.class);
            this.registerView(MemoryCompilerView.class);
            this.registerView(OgnlView.class);
            this.registerView(RedefineView.class);
            this.registerView(RetransformView.class);
            this.registerView(SearchClassView.class);
            this.registerView(SearchMethodView.class);
            this.registerView(LoggerView.class);
            this.registerView(DashboardView.class);
            this.registerView(JvmView.class);
            this.registerView(MBeanView.class);
            this.registerView(PerfCounterView.class);
            this.registerView(ThreadView.class);
            this.registerView(ProfilerView.class);
            this.registerView(EnhancerView.class);
            this.registerView(MonitorView.class);
            this.registerView(StackView.class);
            this.registerView(TimeTunnelView.class);
            this.registerView(TraceView.class);
            this.registerView(WatchView.class);
        }
        catch (Throwable e) {
            logger.error("register result view failed", e);
        }
    }

    public ResultView getResultView(ResultModel model) {
        return this.resultViewMap.get(model.getClass());
    }

    public ResultViewResolver registerView(Class modelClass, ResultView view) {
        this.resultViewMap.put(modelClass, view);
        return this;
    }

    public ResultViewResolver registerView(ResultView view) {
        Class modelClass = ResultViewResolver.getModelClass(view);
        if (modelClass == null) {
            throw new NullPointerException("model class is null");
        }
        return this.registerView(modelClass, view);
    }

    public void registerView(Class<? extends ResultView> viewClass) {
        ResultView view = null;
        try {
            view = viewClass.newInstance();
        }
        catch (Throwable e) {
            throw new RuntimeException("create view instance failure, viewClass:" + viewClass, e);
        }
        this.registerView(view);
    }

    public static <V extends ResultView> Class getModelClass(V view) {
        Class<?> viewClass = view.getClass();
        Method[] declaredMethods = viewClass.getDeclaredMethods();
        for (int i = 0; i < declaredMethods.length; ++i) {
            Class<?>[] parameterTypes;
            Method method = declaredMethods[i];
            if (!method.getName().equals("draw") || (parameterTypes = method.getParameterTypes()).length != 2 || parameterTypes[0] != CommandProcess.class || parameterTypes[1] == ResultModel.class || !ResultModel.class.isAssignableFrom(parameterTypes[1])) continue;
            return parameterTypes[1];
        }
        return null;
    }
}

