/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.model;

import com.taobao.arthas.core.command.model.MethodNode;
import com.taobao.arthas.core.command.model.ThreadNode;
import com.taobao.arthas.core.command.model.ThrowNode;
import com.taobao.arthas.core.command.model.TraceNode;
import com.taobao.arthas.core.util.StringUtils;
import java.util.List;

public class TraceTree {
    private TraceNode root;
    private TraceNode current;
    private int nodeCount = 0;

    public TraceTree(ThreadNode root) {
        this.root = root;
        this.current = root;
    }

    public void begin(String className, String methodName, int lineNumber, boolean isInvoking) {
        TraceNode child = this.findChild(this.current, className, methodName, lineNumber);
        if (child == null) {
            child = new MethodNode(className, methodName, lineNumber, isInvoking);
            this.current.addChild(child);
        }
        child.begin();
        this.current = child;
        ++this.nodeCount;
    }

    private TraceNode findChild(TraceNode node, String className, String methodName, int lineNumber) {
        List<TraceNode> childList = node.getChildren();
        if (childList != null) {
            for (int i = 0; i < childList.size(); ++i) {
                TraceNode child = childList.get(i);
                if (!this.matchNode(child, className, methodName, lineNumber)) continue;
                return child;
            }
        }
        return null;
    }

    private boolean matchNode(TraceNode node, String className, String methodName, int lineNumber) {
        if (node instanceof MethodNode) {
            MethodNode methodNode = (MethodNode)node;
            if (lineNumber != methodNode.getLineNumber()) {
                return false;
            }
            if (className != null ? !className.equals(methodNode.getClassName()) : methodNode.getClassName() != null) {
                return false;
            }
            return methodName != null ? methodName.equals(methodNode.getMethodName()) : methodNode.getMethodName() == null;
        }
        return false;
    }

    public void end() {
        this.current.end();
        if (this.current.parent() != null) {
            this.current = this.current.parent();
        }
    }

    public void end(Throwable throwable, int lineNumber) {
        ThrowNode throwNode = new ThrowNode();
        throwNode.setException(throwable.getClass().getName());
        throwNode.setMessage(throwable.getMessage());
        throwNode.setLineNumber(lineNumber);
        this.current.addChild(throwNode);
        this.end(true);
    }

    public void end(boolean isThrow) {
        if (isThrow) {
            this.current.setMark("throws Exception");
            if (this.current instanceof MethodNode) {
                MethodNode methodNode = (MethodNode)this.current;
                methodNode.setThrow(true);
            }
        }
        this.end();
    }

    public void trim() {
        this.normalizeClassName(this.root);
    }

    private void normalizeClassName(TraceNode node) {
        List<TraceNode> children;
        if (node instanceof MethodNode) {
            MethodNode methodNode = (MethodNode)node;
            String nodeClassName = methodNode.getClassName();
            String normalizeClassName = StringUtils.normalizeClassName(nodeClassName);
            methodNode.setClassName(normalizeClassName);
        }
        if ((children = node.getChildren()) != null) {
            for (int i = 0; i < children.size(); ++i) {
                TraceNode child = children.get(i);
                this.normalizeClassName(child);
            }
        }
    }

    public TraceNode getRoot() {
        return this.root;
    }

    public TraceNode current() {
        return this.current;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }
}

