/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core;

import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import com.taobao.arthas.common.AnsiLog;
import com.taobao.arthas.common.JavaVersionUtils;
import com.taobao.arthas.core.config.Configure;
import com.taobao.middleware.cli.CLI;
import com.taobao.middleware.cli.CLIs;
import com.taobao.middleware.cli.CommandLine;
import com.taobao.middleware.cli.Option;
import com.taobao.middleware.cli.TypedOption;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Properties;

public class Arthas {
    private Arthas(String[] args) throws Exception {
        this.attachAgent(this.parse(args));
    }

    private Configure parse(String[] args) {
        TypedOption pid = new TypedOption().setType(Long.class).setShortName("pid").setRequired(true);
        TypedOption core = new TypedOption().setType(String.class).setShortName("core").setRequired(true);
        TypedOption agent = new TypedOption().setType(String.class).setShortName("agent").setRequired(true);
        TypedOption target = new TypedOption().setType(String.class).setShortName("target-ip");
        TypedOption telnetPort = new TypedOption().setType(Integer.class).setShortName("telnet-port");
        TypedOption httpPort = new TypedOption().setType(Integer.class).setShortName("http-port");
        TypedOption sessionTimeout = new TypedOption().setType(Integer.class).setShortName("session-timeout");
        TypedOption username = new TypedOption().setType(String.class).setShortName("username");
        TypedOption password = new TypedOption().setType(String.class).setShortName("password");
        TypedOption tunnelServer = new TypedOption().setType(String.class).setShortName("tunnel-server");
        TypedOption agentId = new TypedOption().setType(String.class).setShortName("agent-id");
        TypedOption appName = new TypedOption().setType(String.class).setShortName("app-name");
        TypedOption statUrl = new TypedOption().setType(String.class).setShortName("stat-url");
        TypedOption disabledCommands = new TypedOption().setType(String.class).setShortName("disabled-commands");
        CLI cli = CLIs.create((String)"arthas").addOption((Option)pid).addOption((Option)core).addOption((Option)agent).addOption((Option)target).addOption((Option)telnetPort).addOption((Option)httpPort).addOption((Option)sessionTimeout).addOption((Option)username).addOption((Option)password).addOption((Option)tunnelServer).addOption((Option)agentId).addOption((Option)appName).addOption((Option)statUrl).addOption((Option)disabledCommands);
        CommandLine commandLine = cli.parse(Arrays.asList(args));
        Configure configure = new Configure();
        configure.setJavaPid((Long)commandLine.getOptionValue("pid"));
        configure.setArthasAgent((String)commandLine.getOptionValue("agent"));
        configure.setArthasCore((String)commandLine.getOptionValue("core"));
        if (commandLine.getOptionValue("session-timeout") != null) {
            configure.setSessionTimeout(((Integer)commandLine.getOptionValue("session-timeout")).intValue());
        }
        if (commandLine.getOptionValue("target-ip") != null) {
            configure.setIp((String)commandLine.getOptionValue("target-ip"));
        }
        if (commandLine.getOptionValue("telnet-port") != null) {
            configure.setTelnetPort((Integer)commandLine.getOptionValue("telnet-port"));
        }
        if (commandLine.getOptionValue("http-port") != null) {
            configure.setHttpPort((Integer)commandLine.getOptionValue("http-port"));
        }
        configure.setUsername((String)commandLine.getOptionValue("username"));
        configure.setPassword((String)commandLine.getOptionValue("password"));
        configure.setTunnelServer((String)commandLine.getOptionValue("tunnel-server"));
        configure.setAgentId((String)commandLine.getOptionValue("agent-id"));
        configure.setStatUrl((String)commandLine.getOptionValue("stat-url"));
        configure.setDisabledCommands((String)commandLine.getOptionValue("disabled-commands"));
        configure.setAppName((String)commandLine.getOptionValue("app-name"));
        return configure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachAgent(Configure configure) throws Exception {
        VirtualMachineDescriptor virtualMachineDescriptor = null;
        for (VirtualMachineDescriptor descriptor : VirtualMachine.list()) {
            String pid = descriptor.id();
            if (!pid.equals(Long.toString(configure.getJavaPid()))) continue;
            virtualMachineDescriptor = descriptor;
            break;
        }
        VirtualMachine virtualMachine = null;
        try {
            virtualMachine = null == virtualMachineDescriptor ? VirtualMachine.attach("" + configure.getJavaPid()) : VirtualMachine.attach(virtualMachineDescriptor);
            Properties targetSystemProperties = virtualMachine.getSystemProperties();
            String targetJavaVersion = JavaVersionUtils.javaVersionStr((Properties)targetSystemProperties);
            String currentJavaVersion = JavaVersionUtils.javaVersionStr();
            if (targetJavaVersion != null && currentJavaVersion != null && !targetJavaVersion.equals(currentJavaVersion)) {
                AnsiLog.warn((String)"Current VM java version: {} do not match target VM java version: {}, attach may fail.", (Object[])new Object[]{currentJavaVersion, targetJavaVersion});
                AnsiLog.warn((String)"Target VM JAVA_HOME is {}, arthas-boot JAVA_HOME is {}, try to set the same JAVA_HOME.", (Object[])new Object[]{targetSystemProperties.getProperty("java.home"), System.getProperty("java.home")});
            }
            String arthasAgentPath = configure.getArthasAgent();
            configure.setArthasAgent(Arthas.encodeArg(arthasAgentPath));
            configure.setArthasCore(Arthas.encodeArg(configure.getArthasCore()));
            virtualMachine.loadAgent(arthasAgentPath, configure.getArthasCore() + ";" + configure.toString());
        }
        finally {
            if (null != virtualMachine) {
                virtualMachine.detach();
            }
        }
    }

    private static String encodeArg(String arg) {
        try {
            return URLEncoder.encode(arg, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return arg;
        }
    }

    public static void main(String[] args) {
        try {
            new Arthas(args);
        }
        catch (Throwable t) {
            AnsiLog.error((String)"Start arthas failed, exception stack trace: ");
            t.printStackTrace();
            System.exit(-1);
        }
    }
}

