/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.advisor.Advice;
import com.taobao.arthas.core.advisor.AdviceListenerAdapter;
import com.taobao.arthas.core.advisor.ArthasMethod;
import com.taobao.arthas.core.command.monitor200.TraceCommand;
import com.taobao.arthas.core.command.monitor200.TraceEntity;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.arthas.core.util.ThreadLocalWatch;

public class AbstractTraceAdviceListener
extends AdviceListenerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTraceAdviceListener.class);
    protected final ThreadLocalWatch threadLocalWatch = new ThreadLocalWatch();
    protected TraceCommand command;
    protected CommandProcess process;
    protected final ThreadLocal<TraceEntity> threadBoundEntity = new ThreadLocal();

    public AbstractTraceAdviceListener(TraceCommand command, CommandProcess process) {
        this.command = command;
        this.process = process;
    }

    protected TraceEntity threadLocalTraceEntity(ClassLoader loader) {
        TraceEntity traceEntity = this.threadBoundEntity.get();
        if (traceEntity == null) {
            traceEntity = new TraceEntity(loader);
            this.threadBoundEntity.set(traceEntity);
        }
        return traceEntity;
    }

    @Override
    public void destroy() {
        this.threadBoundEntity.remove();
    }

    @Override
    public void before(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args) throws Throwable {
        TraceEntity traceEntity = this.threadLocalTraceEntity(loader);
        traceEntity.tree.begin(clazz.getName(), method.getName(), -1, false);
        ++traceEntity.deep;
        this.threadLocalWatch.start();
    }

    @Override
    public void afterReturning(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args, Object returnObject) throws Throwable {
        this.threadLocalTraceEntity((ClassLoader)loader).tree.end();
        Advice advice = Advice.newForAfterRetuning(loader, clazz, method, target, args, returnObject);
        this.finishing(loader, advice);
    }

    @Override
    public void afterThrowing(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args, Throwable throwable) throws Throwable {
        int lineNumber = -1;
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        if (stackTrace.length != 0) {
            lineNumber = stackTrace[0].getLineNumber();
        }
        this.threadLocalTraceEntity((ClassLoader)loader).tree.end(throwable, lineNumber);
        Advice advice = Advice.newForAfterThrowing(loader, clazz, method, target, args, throwable);
        this.finishing(loader, advice);
    }

    public TraceCommand getCommand() {
        return this.command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishing(ClassLoader loader, Advice advice) {
        TraceEntity traceEntity = this.threadLocalTraceEntity(loader);
        double cost = this.threadLocalWatch.costInMillis();
        if (--traceEntity.deep == 0) {
            try {
                boolean conditionResult = this.isConditionMet(this.command.getConditionExpress(), advice, cost);
                if (this.isVerbose()) {
                    this.process.write("Condition express: " + this.command.getConditionExpress() + " , result: " + conditionResult + "\n");
                }
                if (conditionResult) {
                    this.process.times().incrementAndGet();
                    this.process.appendResult(traceEntity.getModel());
                    if (this.isLimitExceeded(this.command.getNumberOfLimit(), this.process.times().get())) {
                        this.abortProcess(this.process, this.command.getNumberOfLimit());
                    }
                }
            }
            catch (Throwable e) {
                logger.warn("trace failed.", e);
                this.process.end(1, "trace failed, condition is: " + this.command.getConditionExpress() + ", " + e.getMessage() + ", visit " + LogUtil.loggingFile() + " for more details.");
            }
            finally {
                this.threadBoundEntity.remove();
            }
        }
    }
}

