/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.advisor;

import com.taobao.arthas.core.advisor.AccessPoint;
import com.taobao.arthas.core.advisor.ArthasMethod;

public class Advice {
    private final ClassLoader loader;
    private final Class<?> clazz;
    private final ArthasMethod method;
    private final Object target;
    private final Object[] params;
    private final Object returnObj;
    private final Throwable throwExp;
    private final boolean isBefore;
    private final boolean isThrow;
    private final boolean isReturn;

    public boolean isBefore() {
        return this.isBefore;
    }

    public boolean isAfterReturning() {
        return this.isReturn;
    }

    public boolean isAfterThrowing() {
        return this.isThrow;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public Object getTarget() {
        return this.target;
    }

    public Object[] getParams() {
        return this.params;
    }

    public Object getReturnObj() {
        return this.returnObj;
    }

    public Throwable getThrowExp() {
        return this.throwExp;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public ArthasMethod getMethod() {
        return this.method;
    }

    private Advice(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] params, Object returnObj, Throwable throwExp, int access) {
        this.loader = loader;
        this.clazz = clazz;
        this.method = method;
        this.target = target;
        this.params = params;
        this.returnObj = returnObj;
        this.throwExp = throwExp;
        this.isBefore = (access & AccessPoint.ACCESS_BEFORE.getValue()) == AccessPoint.ACCESS_BEFORE.getValue();
        this.isThrow = (access & AccessPoint.ACCESS_AFTER_THROWING.getValue()) == AccessPoint.ACCESS_AFTER_THROWING.getValue();
        this.isReturn = (access & AccessPoint.ACCESS_AFTER_RETUNING.getValue()) == AccessPoint.ACCESS_AFTER_RETUNING.getValue();
    }

    public static Advice newForBefore(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] params) {
        return new Advice(loader, clazz, method, target, params, null, null, AccessPoint.ACCESS_BEFORE.getValue());
    }

    public static Advice newForAfterRetuning(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] params, Object returnObj) {
        return new Advice(loader, clazz, method, target, params, returnObj, null, AccessPoint.ACCESS_AFTER_RETUNING.getValue());
    }

    public static Advice newForAfterThrowing(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] params, Throwable throwExp) {
        return new Advice(loader, clazz, method, target, params, null, throwExp, AccessPoint.ACCESS_AFTER_THROWING.getValue());
    }
}

