/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.taobao.arthas.core.command.model.DashboardModel;
import com.taobao.arthas.core.command.model.GcInfoVO;
import com.taobao.arthas.core.command.model.MemoryEntryVO;
import com.taobao.arthas.core.command.model.RuntimeInfoVO;
import com.taobao.arthas.core.command.model.ThreadVO;
import com.taobao.arthas.core.command.model.TomcatInfoVO;
import com.taobao.arthas.core.command.monitor200.DashboardInterruptHandler;
import com.taobao.arthas.core.command.monitor200.ThreadSampler;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.shell.handlers.Handler;
import com.taobao.arthas.core.shell.handlers.shell.QExitHandler;
import com.taobao.arthas.core.shell.session.Session;
import com.taobao.arthas.core.util.NetUtils;
import com.taobao.arthas.core.util.ThreadUtil;
import com.taobao.arthas.core.util.metrics.SumRateCounter;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

@Name(value="dashboard")
@Summary(value="Overview of target jvm's thread, memory, gc, vm, tomcat info.")
@Description(value="\nEXAMPLES:\n  dashboard\n  dashboard -n 10\n  dashboard -i 2000\n\nWIKI:\n  https://arthas.aliyun.com/doc/dashboard")
public class DashboardCommand
extends AnnotatedCommand {
    private static final Logger logger = LoggerFactory.getLogger(DashboardCommand.class);
    private SumRateCounter tomcatRequestCounter = new SumRateCounter();
    private SumRateCounter tomcatErrorCounter = new SumRateCounter();
    private SumRateCounter tomcatReceivedBytesCounter = new SumRateCounter();
    private SumRateCounter tomcatSentBytesCounter = new SumRateCounter();
    private int numOfExecutions = Integer.MAX_VALUE;
    private long interval = 5000L;
    private volatile long count = 0L;
    private volatile Timer timer;

    @Option(shortName="n", longName="number-of-execution")
    @Description(value="The number of times this command will be executed.")
    public void setNumOfExecutions(int numOfExecutions) {
        this.numOfExecutions = numOfExecutions;
    }

    @Option(shortName="i", longName="interval")
    @Description(value="The interval (in ms) between two executions, default is 5000 ms.")
    public void setInterval(long interval) {
        this.interval = interval;
    }

    @Override
    public void process(final CommandProcess process) {
        Session session = process.session();
        this.timer = new Timer("Timer-for-arthas-dashboard-" + session.getSessionId(), true);
        process.interruptHandler(new DashboardInterruptHandler(process, this.timer));
        Handler<Void> stopHandler = new Handler<Void>(){

            @Override
            public void handle(Void event) {
                DashboardCommand.this.stop();
            }
        };
        Handler<Void> restartHandler = new Handler<Void>(){

            @Override
            public void handle(Void event) {
                DashboardCommand.this.restart(process);
            }
        };
        process.suspendHandler(stopHandler);
        process.resumeHandler(restartHandler);
        process.endHandler(stopHandler);
        process.stdinHandler(new QExitHandler(process));
        this.timer.scheduleAtFixedRate((TimerTask)new DashboardTimerTask(process), 0L, this.getInterval());
    }

    public synchronized void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.timer = null;
        }
    }

    public synchronized void restart(CommandProcess process) {
        if (this.timer == null) {
            Session session = process.session();
            this.timer = new Timer("Timer-for-arthas-dashboard-" + session.getSessionId(), true);
            this.timer.scheduleAtFixedRate((TimerTask)new DashboardTimerTask(process), 0L, this.getInterval());
        }
    }

    public int getNumOfExecutions() {
        return this.numOfExecutions;
    }

    public long getInterval() {
        return this.interval;
    }

    private static String beautifyName(String name) {
        return name.replace(' ', '_').toLowerCase();
    }

    private static void addMemoryInfo(DashboardModel dashboardModel) {
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        LinkedHashMap<String, List<MemoryEntryVO>> memoryInfoMap = new LinkedHashMap<String, List<MemoryEntryVO>>();
        dashboardModel.setMemoryInfo(memoryInfoMap);
        MemoryUsage heapMemoryUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        ArrayList<MemoryEntryVO> heapMemEntries = new ArrayList<MemoryEntryVO>();
        heapMemEntries.add(DashboardCommand.createMemoryEntryVO("heap", "heap", heapMemoryUsage));
        for (MemoryPoolMXBean poolMXBean : memoryPoolMXBeans) {
            if (!MemoryType.HEAP.equals((Object)poolMXBean.getType())) continue;
            MemoryUsage usage = poolMXBean.getUsage();
            String poolName = DashboardCommand.beautifyName(poolMXBean.getName());
            heapMemEntries.add(DashboardCommand.createMemoryEntryVO("heap", poolName, usage));
        }
        memoryInfoMap.put("heap", heapMemEntries);
        MemoryUsage nonHeapMemoryUsage = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
        ArrayList<MemoryEntryVO> nonheapMemEntries = new ArrayList<MemoryEntryVO>();
        nonheapMemEntries.add(DashboardCommand.createMemoryEntryVO("nonheap", "nonheap", nonHeapMemoryUsage));
        for (MemoryPoolMXBean poolMXBean : memoryPoolMXBeans) {
            if (!MemoryType.NON_HEAP.equals((Object)poolMXBean.getType())) continue;
            MemoryUsage usage = poolMXBean.getUsage();
            String poolName = DashboardCommand.beautifyName(poolMXBean.getName());
            nonheapMemEntries.add(DashboardCommand.createMemoryEntryVO("nonheap", poolName, usage));
        }
        memoryInfoMap.put("nonheap", nonheapMemEntries);
        DashboardCommand.addBufferPoolMemoryInfo(memoryInfoMap);
    }

    private static void addBufferPoolMemoryInfo(Map<String, List<MemoryEntryVO>> memoryInfoMap) {
        try {
            ArrayList<MemoryEntryVO> bufferPoolMemEntries = new ArrayList<MemoryEntryVO>();
            Class<?> bufferPoolMXBeanClass = Class.forName("java.lang.management.BufferPoolMXBean");
            List<BufferPoolMXBean> bufferPoolMXBeans = ManagementFactory.getPlatformMXBeans(bufferPoolMXBeanClass);
            for (BufferPoolMXBean mbean : bufferPoolMXBeans) {
                long used = mbean.getMemoryUsed();
                long total = mbean.getTotalCapacity();
                bufferPoolMemEntries.add(new MemoryEntryVO("buffer_pool", mbean.getName(), used, total, Long.MIN_VALUE));
            }
            memoryInfoMap.put("buffer_pool", bufferPoolMemEntries);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static void addRuntimeInfo(DashboardModel dashboardModel) {
        RuntimeInfoVO runtimeInfo = new RuntimeInfoVO();
        runtimeInfo.setOsName(System.getProperty("os.name"));
        runtimeInfo.setOsVersion(System.getProperty("os.version"));
        runtimeInfo.setJavaVersion(System.getProperty("java.version"));
        runtimeInfo.setJavaHome(System.getProperty("java.home"));
        runtimeInfo.setSystemLoadAverage(ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage());
        runtimeInfo.setProcessors(Runtime.getRuntime().availableProcessors());
        runtimeInfo.setUptime(ManagementFactory.getRuntimeMXBean().getUptime() / 1000L);
        dashboardModel.setRuntimeInfo(runtimeInfo);
    }

    private static MemoryEntryVO createMemoryEntryVO(String type, String name, MemoryUsage memoryUsage) {
        return new MemoryEntryVO(type, name, memoryUsage.getUsed(), memoryUsage.getCommitted(), memoryUsage.getMax());
    }

    private static void addGcInfo(DashboardModel dashboardModel) {
        ArrayList<GcInfoVO> gcInfos = new ArrayList<GcInfoVO>();
        dashboardModel.setGcInfos(gcInfos);
        List<GarbageCollectorMXBean> garbageCollectorMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcMXBean : garbageCollectorMxBeans) {
            String name = gcMXBean.getName();
            gcInfos.add(new GcInfoVO(DashboardCommand.beautifyName(name), gcMXBean.getCollectionCount(), gcMXBean.getCollectionTime()));
        }
    }

    private void addTomcatInfo(DashboardModel dashboardModel) {
        NetUtils.Response threadPoolResponse;
        if (!NetUtils.request("http://localhost:8006").isSuccess()) {
            return;
        }
        TomcatInfoVO tomcatInfoVO = new TomcatInfoVO();
        dashboardModel.setTomcatInfo(tomcatInfoVO);
        String threadPoolPath = "http://localhost:8006/connector/threadpool";
        String connectorStatPath = "http://localhost:8006/connector/stats";
        NetUtils.Response connectorStatResponse = NetUtils.request(connectorStatPath);
        if (connectorStatResponse.isSuccess()) {
            ArrayList<TomcatInfoVO.ConnectorStats> connectorStats = new ArrayList<TomcatInfoVO.ConnectorStats>();
            List tomcatConnectorStats = JSON.parseArray((String)connectorStatResponse.getContent(), JSONObject.class);
            for (JSONObject stat : tomcatConnectorStats) {
                String connectorName = stat.getString("name").replace("\"", "");
                long bytesReceived = stat.getLongValue("bytesReceived");
                long bytesSent = stat.getLongValue("bytesSent");
                long processingTime = stat.getLongValue("processingTime");
                long requestCount = stat.getLongValue("requestCount");
                long errorCount = stat.getLongValue("errorCount");
                this.tomcatRequestCounter.update(requestCount);
                this.tomcatErrorCounter.update(errorCount);
                this.tomcatReceivedBytesCounter.update(bytesReceived);
                this.tomcatSentBytesCounter.update(bytesSent);
                double qps = this.tomcatRequestCounter.rate();
                double rt = (double)processingTime / (double)requestCount;
                double errorRate = this.tomcatErrorCounter.rate();
                long receivedBytesRate = new Double(this.tomcatReceivedBytesCounter.rate()).longValue();
                long sentBytesRate = new Double(this.tomcatSentBytesCounter.rate()).longValue();
                TomcatInfoVO.ConnectorStats connectorStat = new TomcatInfoVO.ConnectorStats();
                connectorStat.setName(connectorName);
                connectorStat.setQps(qps);
                connectorStat.setRt(rt);
                connectorStat.setError(errorRate);
                connectorStat.setReceived(receivedBytesRate);
                connectorStat.setSent(sentBytesRate);
                connectorStats.add(connectorStat);
            }
            tomcatInfoVO.setConnectorStats(connectorStats);
        }
        if ((threadPoolResponse = NetUtils.request(threadPoolPath)).isSuccess()) {
            ArrayList<TomcatInfoVO.ThreadPool> threadPools = new ArrayList<TomcatInfoVO.ThreadPool>();
            List threadPoolInfos = JSON.parseArray((String)threadPoolResponse.getContent(), JSONObject.class);
            for (JSONObject info : threadPoolInfos) {
                String name = info.getString("name").replace("\"", "");
                long busy = info.getLongValue("threadBusy");
                long total = info.getLongValue("threadCount");
                threadPools.add(new TomcatInfoVO.ThreadPool(name, busy, total));
            }
            tomcatInfoVO.setThreadPools(threadPools);
        }
    }

    private class DashboardTimerTask
    extends TimerTask {
        private CommandProcess process;
        private ThreadSampler threadSampler;

        public DashboardTimerTask(CommandProcess process) {
            this.process = process;
            this.threadSampler = new ThreadSampler();
        }

        @Override
        public void run() {
            try {
                if (DashboardCommand.this.count >= (long)DashboardCommand.this.getNumOfExecutions()) {
                    DashboardCommand.this.timer.cancel();
                    DashboardCommand.this.timer.purge();
                    this.process.end(0, "Process ends after " + DashboardCommand.this.getNumOfExecutions() + " time(s).");
                    return;
                }
                DashboardModel dashboardModel = new DashboardModel();
                List<ThreadVO> threads = ThreadUtil.getThreads();
                dashboardModel.setThreads(this.threadSampler.sample(threads));
                DashboardCommand.addMemoryInfo(dashboardModel);
                DashboardCommand.addGcInfo(dashboardModel);
                DashboardCommand.addRuntimeInfo(dashboardModel);
                DashboardCommand.this.addTomcatInfo(dashboardModel);
                this.process.appendResult(dashboardModel);
                DashboardCommand.this.count++;
                this.process.times().incrementAndGet();
            }
            catch (Throwable e) {
                String msg = "process dashboard failed: " + e.getMessage();
                logger.error(msg, e);
                this.process.end(-1, msg);
            }
        }
    }
}

