/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.taobao.arthas.core.GlobalOptions;
import com.taobao.arthas.core.advisor.AdviceListener;
import com.taobao.arthas.core.command.monitor200.EnhancerCommand;
import com.taobao.arthas.core.command.monitor200.MonitorAdviceListener;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.shell.handlers.Handler;
import com.taobao.arthas.core.util.SearchUtils;
import com.taobao.arthas.core.util.matcher.Matcher;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;

@Name(value="monitor")
@Summary(value="Monitor method execution statistics, e.g. total/success/failure count, average rt, fail rate, etc. ")
@Description(value="\nExamples:\n  monitor org.apache.commons.lang.StringUtils isBlank\n  monitor org.apache.commons.lang.StringUtils isBlank -c 5\n  monitor org.apache.commons.lang.StringUtils isBlank params[0]!=null\n  monitor -b org.apache.commons.lang.StringUtils isBlank params[0]!=null\n  monitor -E org\\.apache\\.commons\\.lang\\.StringUtils isBlank\n\nWIKI:\n  https://arthas.aliyun.com/doc/monitor")
public class MonitorCommand
extends EnhancerCommand {
    private String classPattern;
    private String methodPattern;
    private String conditionExpress;
    private int cycle = 60;
    private boolean isRegEx = false;
    private int numberOfLimit = 100;
    private boolean isBefore = false;

    @Argument(argName="class-pattern", index=0)
    @Description(value="Path and classname of Pattern Matching")
    public void setClassPattern(String classPattern) {
        this.classPattern = classPattern;
    }

    @Argument(argName="method-pattern", index=1)
    @Description(value="Method of Pattern Matching")
    public void setMethodPattern(String methodPattern) {
        this.methodPattern = methodPattern;
    }

    @Argument(argName="condition-express", index=2, required=false)
    @Description(value="Conditional expression in ognl style, for example:\n  TRUE  : 1==1\n  TRUE  : true\n  FALSE : false\n  TRUE  : 'params.length>=0'\n  FALSE : 1==2\n")
    public void setConditionExpress(String conditionExpress) {
        this.conditionExpress = conditionExpress;
    }

    @Option(shortName="c", longName="cycle")
    @Description(value="The monitor interval (in seconds), 60 seconds by default")
    public void setCycle(int cycle) {
        this.cycle = cycle;
    }

    @Option(shortName="E", longName="regex")
    @Description(value="Enable regular expression to match (wildcard matching by default)")
    public void setRegEx(boolean regEx) {
        this.isRegEx = regEx;
    }

    @Option(shortName="n", longName="limits")
    @Description(value="Threshold of execution times")
    public void setNumberOfLimit(int numberOfLimit) {
        this.numberOfLimit = numberOfLimit;
    }

    @Option(shortName="b", longName="before", flag=true)
    @Description(value="Evaluate the condition-express before method invoke")
    public void setBefore(boolean before) {
        this.isBefore = before;
    }

    public String getClassPattern() {
        return this.classPattern;
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    public String getConditionExpress() {
        return this.conditionExpress;
    }

    public int getCycle() {
        return this.cycle;
    }

    public boolean isRegEx() {
        return this.isRegEx;
    }

    public int getNumberOfLimit() {
        return this.numberOfLimit;
    }

    public boolean isBefore() {
        return this.isBefore;
    }

    @Override
    protected Matcher getClassNameMatcher() {
        if (this.classNameMatcher == null) {
            this.classNameMatcher = SearchUtils.classNameMatcher(this.getClassPattern(), this.isRegEx());
        }
        return this.classNameMatcher;
    }

    @Override
    protected Matcher getMethodNameMatcher() {
        if (this.methodNameMatcher == null) {
            this.methodNameMatcher = SearchUtils.classNameMatcher(this.getMethodPattern(), this.isRegEx());
        }
        return this.methodNameMatcher;
    }

    @Override
    protected AdviceListener getAdviceListener(CommandProcess process) {
        final MonitorAdviceListener listener = new MonitorAdviceListener(this, process, GlobalOptions.verbose || this.verbose);
        process.suspendHandler(new Handler<Void>(){

            @Override
            public void handle(Void event) {
                listener.destroy();
            }
        });
        process.resumeHandler(new Handler<Void>(){

            @Override
            public void handle(Void event) {
                listener.create();
            }
        });
        return listener;
    }
}

