/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.view;

import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.view.View;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class TableView
implements View {
    public static final int BORDER_TOP = 1;
    public static final int BORDER_BOTTOM = 2;
    private final ColumnDefine[] columnDefineArray;
    private boolean hasBorder;
    private int borders = 3;
    private int padding;

    public TableView(ColumnDefine[] columnDefineArray) {
        this.columnDefineArray = null == columnDefineArray ? new ColumnDefine[]{} : columnDefineArray;
    }

    public TableView(int columnNum) {
        this.columnDefineArray = new ColumnDefine[columnNum];
        for (int index = 0; index < this.columnDefineArray.length; ++index) {
            this.columnDefineArray[index] = new ColumnDefine();
        }
    }

    private boolean isAnyBorder(int ... borders) {
        if (null == borders) {
            return false;
        }
        for (int b : borders) {
            if ((this.borders & b) != b) continue;
            return true;
        }
        return false;
    }

    public int borders() {
        return this.borders;
    }

    public TableView borders(int border) {
        this.borders = border;
        return this;
    }

    @Override
    public String draw() {
        StringBuilder tableSB = new StringBuilder();
        int[] widthCacheArray = new int[this.getColumnCount()];
        for (int index = 0; index < widthCacheArray.length; ++index) {
            widthCacheArray[index] = Math.abs(this.columnDefineArray[index].getWidth());
        }
        int tableHigh = this.getTableHigh();
        for (int rowIndex = 0; rowIndex < tableHigh; ++rowIndex) {
            boolean isLastRow;
            boolean isFirstRow = rowIndex == 0;
            boolean bl = isLastRow = rowIndex == tableHigh - 1;
            if (isFirstRow && this.hasBorder() && this.isAnyBorder(1)) {
                tableSB.append(this.drawSeparationLine(widthCacheArray)).append("\n");
            }
            if (!isFirstRow && this.hasBorder()) {
                tableSB.append(this.drawSeparationLine(widthCacheArray)).append("\n");
            }
            tableSB.append(this.drawRow(widthCacheArray, rowIndex));
            if (!isLastRow || !this.hasBorder() || !this.isAnyBorder(2)) continue;
            tableSB.append(this.drawSeparationLine(widthCacheArray)).append("\n");
        }
        return tableSB.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String drawRow(int[] widthCacheArray, int rowIndex) {
        StringBuilder rowSB = new StringBuilder();
        Scanner[] scannerArray = new Scanner[this.getColumnCount()];
        try {
            boolean hasNext;
            do {
                hasNext = false;
                StringBuilder segmentSB = new StringBuilder();
                for (int colIndex = 0; colIndex < this.getColumnCount(); ++colIndex) {
                    String data;
                    Scanner scanner;
                    boolean isLastColOfRow;
                    String borderChar = this.hasBorder() ? "|" : "";
                    int width = widthCacheArray[colIndex];
                    boolean bl = isLastColOfRow = colIndex == widthCacheArray.length - 1;
                    if (null == scannerArray[colIndex]) {
                        scannerArray[colIndex] = new Scanner(new StringReader(StringUtils.wrap(this.getData(rowIndex, this.columnDefineArray[colIndex]), width)));
                    }
                    if ((scanner = scannerArray[colIndex]).hasNext()) {
                        data = scanner.nextLine();
                        hasNext = true;
                    } else {
                        data = "";
                    }
                    if (width > 0) {
                        ColumnDefine columnDefine = this.columnDefineArray[colIndex];
                        String dataFormat = this.getDataFormat(columnDefine, width);
                        String paddingChar = StringUtils.repeat(" ", this.padding);
                        segmentSB.append(String.format(borderChar + paddingChar + dataFormat + paddingChar, data));
                    }
                    if (!isLastColOfRow) continue;
                    segmentSB.append(borderChar).append("\n");
                }
                if (!hasNext) continue;
                rowSB.append((CharSequence)segmentSB);
            } while (hasNext);
            String string = rowSB.toString();
            return string;
        }
        finally {
            for (Scanner scanner : scannerArray) {
                if (null == scanner) continue;
                scanner.close();
            }
        }
    }

    private String getData(int rowIndex, ColumnDefine columnDefine) {
        return columnDefine.getHigh() <= rowIndex ? "" : (String)columnDefine.dataList.get(rowIndex);
    }

    private String getDataFormat(ColumnDefine columnDefine, int width) {
        switch (columnDefine.align) {
            case RIGHT: {
                return "%" + width + "s";
            }
        }
        return "%-" + width + "s";
    }

    private int getTableHigh() {
        int tableHigh = 0;
        for (ColumnDefine columnDefine : this.columnDefineArray) {
            tableHigh = Math.max(tableHigh, columnDefine.getHigh());
        }
        return tableHigh;
    }

    private String drawSeparationLine(int[] widthCacheArray) {
        StringBuilder separationLineSB = new StringBuilder();
        for (int width : widthCacheArray) {
            if (width <= 0) continue;
            separationLineSB.append("+").append(StringUtils.repeat("-", width + 2 * this.padding));
        }
        return separationLineSB.append("+").toString();
    }

    public TableView addRow(Object ... columnDataArray) {
        if (null == columnDataArray) {
            return this;
        }
        for (int index = 0; index < this.columnDefineArray.length; ++index) {
            ColumnDefine columnDefine = this.columnDefineArray[index];
            if (index < columnDataArray.length && null != columnDataArray[index]) {
                columnDefine.dataList.add(StringUtils.replace(columnDataArray[index].toString(), "\t", "    "));
                continue;
            }
            columnDefine.dataList.add("");
        }
        return this;
    }

    public TableView hasBorder(boolean hasBorder) {
        this.hasBorder = hasBorder;
        return this;
    }

    public boolean hasBorder() {
        return this.hasBorder;
    }

    public TableView padding(int padding) {
        this.padding = padding;
        return this;
    }

    public int getColumnCount() {
        return this.columnDefineArray.length;
    }

    public static class ColumnDefine {
        private final int width;
        private final boolean isAutoResize;
        private final Align align;
        private final List<String> dataList = new ArrayList<String>();

        public ColumnDefine(int width, boolean isAutoResize, Align align) {
            this.width = width;
            this.isAutoResize = isAutoResize;
            this.align = align;
        }

        public ColumnDefine(Align align) {
            this(0, true, align);
        }

        public ColumnDefine() {
            this(Align.LEFT);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getWidth() {
            if (!this.isAutoResize) {
                return this.width;
            }
            int maxWidth = 0;
            for (String data : this.dataList) {
                Scanner scanner = new Scanner(new StringReader(data));
                try {
                    while (scanner.hasNext()) {
                        maxWidth = Math.max(StringUtils.length(scanner.nextLine()), maxWidth);
                    }
                }
                finally {
                    scanner.close();
                }
            }
            return maxWidth;
        }

        public int getHigh() {
            return this.dataList.size();
        }
    }

    public static enum Align {
        LEFT,
        RIGHT;

    }
}

