/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util;

import com.alibaba.arthas.deps.ch.qos.logback.classic.LoggerContext;
import com.alibaba.arthas.deps.ch.qos.logback.classic.joran.JoranConfigurator;
import com.alibaba.arthas.deps.ch.qos.logback.core.Appender;
import com.alibaba.arthas.deps.ch.qos.logback.core.Context;
import com.alibaba.arthas.deps.ch.qos.logback.core.rolling.RollingFileAppender;
import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.common.AnsiLog;
import com.taobao.arthas.core.env.ArthasEnvironment;
import java.io.File;
import java.util.Iterator;

public class LogUtil {
    public static final String LOGGING_CONFIG_PROPERTY = "arthas.logging.config";
    public static final String LOGGING_CONFIG = "${arthas.logging.config:${arthas.home}/logback.xml}";
    public static final String FILE_NAME_PROPERTY = "arthas.logging.file.name";
    public static final String ARTHAS_LOG_FILE = "ARTHAS_LOG_FILE";
    public static final String FILE_PATH_PROPERTY = "arthas.logging.file.path";
    public static final String ARTHAS_LOG_PATH = "ARTHAS_LOG_PATH";
    private static String logFile = "";

    public static LoggerContext initLooger(ArthasEnvironment env) {
        String loggingConfig = env.resolvePlaceholders(LOGGING_CONFIG);
        if (loggingConfig == null || loggingConfig.trim().isEmpty()) {
            return null;
        }
        AnsiLog.debug((String)("arthas logging file: " + loggingConfig));
        File configFile = new File(loggingConfig);
        if (!configFile.isFile()) {
            AnsiLog.error((String)("can not find arthas logging config: " + loggingConfig));
            return null;
        }
        try {
            String filePath;
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            loggerContext.reset();
            String fileName = env.getProperty(FILE_NAME_PROPERTY);
            if (fileName != null) {
                loggerContext.putProperty(ARTHAS_LOG_FILE, fileName);
            }
            if ((filePath = env.getProperty(FILE_PATH_PROPERTY)) != null) {
                loggerContext.putProperty(ARTHAS_LOG_PATH, filePath);
            }
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)loggerContext);
            configurator.doConfigure(configFile.toURI().toURL());
            Iterator appenders = loggerContext.getLogger("root").iteratorForAppenders();
            while (appenders.hasNext()) {
                RollingFileAppender fileAppender;
                Appender appender = (Appender)appenders.next();
                if (!(appender instanceof RollingFileAppender) || !"ARTHAS".equalsIgnoreCase((fileAppender = (RollingFileAppender)appender).getName())) continue;
                logFile = fileAppender.getFile();
            }
            return loggerContext;
        }
        catch (Throwable e) {
            AnsiLog.error((String)("try to load arthas logging config file error: " + configFile), (Object[])new Object[]{e});
            return null;
        }
    }

    public static String loggingFile() {
        if (logFile == null || logFile.trim().isEmpty()) {
            return "arthas.log";
        }
        return logFile;
    }

    public static String loggingDir() {
        String parent;
        if (logFile != null && !logFile.isEmpty() && (parent = new File(logFile).getParent()) != null) {
            return parent;
        }
        return new File("").getAbsolutePath();
    }

    public static String cacheDir() {
        File logsDir = new File(LogUtil.loggingDir()).getParentFile();
        if (logsDir.exists()) {
            File arthasCacheDir = new File(logsDir, "arthas-cache");
            arthasCacheDir.mkdirs();
            return arthasCacheDir.getAbsolutePath();
        }
        File arthasCacheDir = new File("arthas-cache");
        arthasCacheDir.mkdirs();
        return arthasCacheDir.getAbsolutePath();
    }

    public static Logger getResultLogger() {
        return LoggerFactory.getLogger((String)"result");
    }
}

