/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.klass100;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.command.model.MethodVO;
import com.taobao.arthas.core.command.model.RowAffectModel;
import com.taobao.arthas.core.command.model.SearchMethodModel;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.ClassUtils;
import com.taobao.arthas.core.util.SearchUtils;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.util.affect.RowAffect;
import com.taobao.arthas.core.util.matcher.Matcher;
import com.taobao.arthas.core.util.matcher.RegexMatcher;
import com.taobao.arthas.core.util.matcher.WildcardMatcher;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Set;

@Name(value="sm")
@Summary(value="Search the method of classes loaded by JVM")
@Description(value="\nEXAMPLES:\n  sm java.lang.String\n  sm -d org.apache.commons.lang.StringUtils\n  sm -d org/apache/commons/lang/StringUtils\n  sm *StringUtils *\n  sm -Ed org\\\\.apache\\\\.commons\\\\.lang\\.StringUtils .*\n\nWIKI:\n  https://arthas.aliyun.com/doc/sm")
public class SearchMethodCommand
extends AnnotatedCommand {
    private static final Logger logger = LoggerFactory.getLogger(SearchMethodCommand.class);
    private String classPattern;
    private String methodPattern;
    private String hashCode = null;
    private boolean isDetail = false;
    private boolean isRegEx = false;
    private int numberOfLimit = 100;

    @Argument(argName="class-pattern", index=0)
    @Description(value="Class name pattern, use either '.' or '/' as separator")
    public void setClassPattern(String classPattern) {
        this.classPattern = classPattern;
    }

    @Argument(argName="method-pattern", index=1, required=false)
    @Description(value="Method name pattern")
    public void setMethodPattern(String methodPattern) {
        this.methodPattern = methodPattern;
    }

    @Option(shortName="d", longName="details", flag=true)
    @Description(value="Display the details of method")
    public void setDetail(boolean detail) {
        this.isDetail = detail;
    }

    @Option(shortName="E", longName="regex", flag=true)
    @Description(value="Enable regular expression to match (wildcard matching by default)")
    public void setRegEx(boolean regEx) {
        this.isRegEx = regEx;
    }

    @Option(shortName="c", longName="classloader")
    @Description(value="The hash code of the special class's classLoader")
    public void setHashCode(String hashCode) {
        this.hashCode = hashCode;
    }

    @Option(shortName="n", longName="limits")
    @Description(value="Maximum number of matching classes (100 by default)")
    public void setNumberOfLimit(int numberOfLimit) {
        this.numberOfLimit = numberOfLimit;
    }

    @Override
    public void process(CommandProcess process) {
        RowAffect affect = new RowAffect();
        Instrumentation inst = process.session().getInstrumentation();
        Matcher<String> methodNameMatcher = this.methodNameMatcher();
        Set<Class<?>> matchedClasses = SearchUtils.searchClass(inst, this.classPattern, this.isRegEx, this.hashCode);
        if (this.numberOfLimit > 0 && matchedClasses.size() > this.numberOfLimit) {
            process.end(-1, "The number of matching classes is greater than : " + this.numberOfLimit + ". \nPlease specify a more accurate 'class-patten' or use the parameter '-n' to change the maximum number of matching classes.");
            return;
        }
        for (Class<?> clazz : matchedClasses) {
            try {
                MethodVO methodInfo;
                for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                    if (!methodNameMatcher.matching("<init>")) continue;
                    methodInfo = ClassUtils.createMethodInfo(constructor, clazz, this.isDetail);
                    process.appendResult(new SearchMethodModel(methodInfo, this.isDetail));
                    affect.rCnt(1);
                }
                for (Executable executable : clazz.getDeclaredMethods()) {
                    if (!methodNameMatcher.matching(((Method)executable).getName())) continue;
                    methodInfo = ClassUtils.createMethodInfo((Method)executable, clazz, this.isDetail);
                    process.appendResult(new SearchMethodModel(methodInfo, this.isDetail));
                    affect.rCnt(1);
                }
            }
            catch (Error e) {
                String msg = String.format("process class failed: %s, error: %s", clazz.getName(), e.toString());
                logger.error(msg, (Throwable)e);
                process.end(1, msg);
                return;
            }
        }
        process.appendResult(new RowAffectModel(affect));
        process.end();
    }

    private Matcher<String> methodNameMatcher() {
        if (StringUtils.isBlank(this.methodPattern)) {
            this.methodPattern = this.isRegEx ? ".*" : "*";
        }
        return this.isRegEx ? new RegexMatcher(this.methodPattern) : new WildcardMatcher(this.methodPattern);
    }

    @Override
    public void complete(Completion completion) {
        int argumentIndex = CompletionUtils.detectArgumentIndex(completion);
        if (argumentIndex == 1) {
            if (!CompletionUtils.completeClassName(completion)) {
                super.complete(completion);
            }
            return;
        }
        if (argumentIndex == 2) {
            if (!CompletionUtils.completeMethodName(completion)) {
                super.complete(completion);
            }
            return;
        }
        super.complete(completion);
    }
}

