/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.klass100;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.command.klass100.ClassDumpTransformer;
import com.taobao.arthas.core.command.model.ClassVO;
import com.taobao.arthas.core.command.model.DumpClassModel;
import com.taobao.arthas.core.command.model.DumpClassVO;
import com.taobao.arthas.core.command.model.MessageModel;
import com.taobao.arthas.core.command.model.RowAffectModel;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.shell.command.ExitStatus;
import com.taobao.arthas.core.util.ClassUtils;
import com.taobao.arthas.core.util.CommandUtils;
import com.taobao.arthas.core.util.InstrumentationUtils;
import com.taobao.arthas.core.util.SearchUtils;
import com.taobao.arthas.core.util.affect.RowAffect;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.DefaultValue;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Name(value="dump")
@Summary(value="Dump class byte array from JVM")
@Description(value="\nEXAMPLES:\n  dump java.lang.String\n  dump -d /tmp/output java.lang.String\n  dump org/apache/commons/lang/StringUtils\n  dump *StringUtils\n  dump -E org\\\\.apache\\\\.commons\\\\.lang\\\\.StringUtils\n\nWIKI:\n  https://alibaba.github.io/arthas/dump")
public class DumpClassCommand
extends AnnotatedCommand {
    private static final Logger logger = LoggerFactory.getLogger(DumpClassCommand.class);
    private String classPattern;
    private String code = null;
    private boolean isRegEx = false;
    private String directory;
    private int limit;

    @Argument(index=0, argName="class-pattern")
    @Description(value="Class name pattern, use either '.' or '/' as separator")
    public void setClassPattern(String classPattern) {
        this.classPattern = classPattern;
    }

    @Option(shortName="c", longName="code")
    @Description(value="The hash code of the special class's classLoader")
    public void setCode(String code) {
        this.code = code;
    }

    @Option(shortName="E", longName="regex", flag=true)
    @Description(value="Enable regular expression to match (wildcard matching by default)")
    public void setRegEx(boolean regEx) {
        this.isRegEx = regEx;
    }

    @Option(shortName="d", longName="directory")
    @Description(value="Sets the destination directory for class files")
    public void setDirectory(String directory) {
        this.directory = directory;
    }

    @Option(shortName="l", longName="limit")
    @Description(value="The limit of dump classes size, default value is 5")
    @DefaultValue(value="50")
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public void process(CommandProcess process) {
        RowAffect effect = new RowAffect();
        try {
            File dir;
            if (this.directory != null && (dir = new File(this.directory)).isFile()) {
                process.end(-1, this.directory + " :is not a directory, please check it");
                return;
            }
            ExitStatus status = null;
            Instrumentation inst = process.session().getInstrumentation();
            Set<Class<?>> matchedClasses = SearchUtils.searchClass(inst, this.classPattern, this.isRegEx, this.code);
            status = matchedClasses == null || matchedClasses.isEmpty() ? this.processNoMatch(process) : (matchedClasses.size() > this.limit ? this.processMatches(process, matchedClasses) : this.processMatch(process, effect, inst, matchedClasses));
            process.appendResult(new RowAffectModel(effect));
            CommandUtils.end(process, status);
        }
        catch (Throwable e) {
            logger.error("processing error", e);
            process.end(-1, "processing error");
        }
    }

    @Override
    public void complete(Completion completion) {
        if (!CompletionUtils.completeClassName(completion)) {
            super.complete(completion);
        }
    }

    private ExitStatus processMatch(CommandProcess process, RowAffect effect, Instrumentation inst, Set<Class<?>> matchedClasses) {
        try {
            Map<Class<?>, File> classFiles = this.dump(inst, matchedClasses);
            ArrayList<DumpClassVO> dumpedClasses = new ArrayList<DumpClassVO>(classFiles.size());
            for (Map.Entry<Class<?>, File> entry : classFiles.entrySet()) {
                Class<?> clazz = entry.getKey();
                File file = entry.getValue();
                DumpClassVO dumpClassVO = new DumpClassVO();
                dumpClassVO.setLocation(file.getCanonicalPath());
                ClassUtils.fillSimpleClassVO(clazz, dumpClassVO);
                dumpedClasses.add(dumpClassVO);
            }
            process.appendResult(new DumpClassModel().setDumpedClasses(dumpedClasses));
            effect.rCnt(classFiles.keySet().size());
            return ExitStatus.success();
        }
        catch (Throwable t) {
            logger.error("dump: fail to dump classes: " + matchedClasses, t);
            return ExitStatus.failure(-1, "dump: fail to dump classes: " + matchedClasses);
        }
    }

    private ExitStatus processMatches(CommandProcess process, Set<Class<?>> matchedClasses) {
        String msg = String.format("Found more than %d class for: %s, Please Try to specify the classloader with the -c option, or try to use --limit option.", this.limit, this.classPattern);
        process.appendResult(new MessageModel(msg));
        List<ClassVO> classVOs = ClassUtils.createClassVOList(matchedClasses);
        process.appendResult(new DumpClassModel().setMatchedClasses(classVOs));
        return ExitStatus.failure(-1, msg);
    }

    private ExitStatus processNoMatch(CommandProcess process) {
        return ExitStatus.failure(-1, "No class found for: " + this.classPattern);
    }

    private Map<Class<?>, File> dump(Instrumentation inst, Set<Class<?>> classes) throws UnmodifiableClassException {
        ClassDumpTransformer transformer = null;
        transformer = this.directory != null ? new ClassDumpTransformer(classes, new File(this.directory)) : new ClassDumpTransformer(classes);
        InstrumentationUtils.retransformClasses(inst, transformer, classes);
        return transformer.getDumpResult();
    }
}

