/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.view;

import com.taobao.arthas.core.command.model.ChangeResultVO;
import com.taobao.arthas.core.command.model.EnhancerAffectVO;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.text.Decoration;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.util.List;
import java.util.Map;

public class ViewRenderUtil {
    public static String renderKeyValueTable(Map<String, String> map, int width) {
        TableElement table = new TableElement(new int[]{1, 4}).leftCellPadding(1).rightCellPadding(1);
        table.row(true, new Element[]{Element.label((String)"KEY").style(Decoration.bold.bold()), Element.label((String)"VALUE").style(Decoration.bold.bold())});
        for (Map.Entry<String, String> entry : map.entrySet()) {
            table.row(new String[]{entry.getKey(), entry.getValue()});
        }
        return RenderUtil.render((Element)table, (int)width);
    }

    public static TableElement renderChangeResult(ChangeResultVO result) {
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        table.row(true, new Element[]{Element.label((String)"NAME").style(Decoration.bold.bold()), Element.label((String)"BEFORE-VALUE").style(Decoration.bold.bold()), Element.label((String)"AFTER-VALUE").style(Decoration.bold.bold())});
        table.row(new String[]{result.getName(), StringUtils.objectToString(result.getBeforeValue()), StringUtils.objectToString(result.getAfterValue())});
        return table;
    }

    public static String renderEnhancerAffect(EnhancerAffectVO affectVO) {
        List<String> methods;
        StringBuilder infoSB = new StringBuilder();
        List<String> classDumpFiles = affectVO.getClassDumpFiles();
        if (classDumpFiles != null) {
            for (String classDumpFile : classDumpFiles) {
                infoSB.append("[dump: ").append(classDumpFile).append("]\n");
            }
        }
        if ((methods = affectVO.getMethods()) != null) {
            for (String method : methods) {
                infoSB.append("[Affect method: ").append(method).append("]\n");
            }
        }
        infoSB.append(String.format("Affect(class count: %d , method count: %d) cost in %s ms, listenerId: %d", affectVO.getClassCount(), affectVO.getMethodCount(), affectVO.getCost(), affectVO.getListenerId()));
        if (affectVO.getThrowable() != null) {
            infoSB.append("\nEnhance error! exception: " + affectVO.getThrowable());
        }
        infoSB.append("\n");
        return infoSB.toString();
    }
}

