/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.server;

import com.alibaba.arthas.deps.ch.qos.logback.classic.LoggerContext;
import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.alibaba.arthas.tunnel.client.TunnelClient;
import com.taobao.arthas.common.AnsiLog;
import com.taobao.arthas.common.PidUtils;
import com.taobao.arthas.core.advisor.TransformerManager;
import com.taobao.arthas.core.command.BuiltinCommandPack;
import com.taobao.arthas.core.config.BinderUtils;
import com.taobao.arthas.core.config.Configure;
import com.taobao.arthas.core.config.FeatureCodec;
import com.taobao.arthas.core.env.ArthasEnvironment;
import com.taobao.arthas.core.env.MapPropertySource;
import com.taobao.arthas.core.env.PropertiesPropertySource;
import com.taobao.arthas.core.shell.ShellServer;
import com.taobao.arthas.core.shell.ShellServerOptions;
import com.taobao.arthas.core.shell.command.CommandResolver;
import com.taobao.arthas.core.shell.handlers.BindHandler;
import com.taobao.arthas.core.shell.impl.ShellServerImpl;
import com.taobao.arthas.core.shell.term.impl.HttpTermServer;
import com.taobao.arthas.core.shell.term.impl.httptelnet.HttpTelnetTermServer;
import com.taobao.arthas.core.util.ArthasBanner;
import com.taobao.arthas.core.util.FileUtils;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.arthas.core.util.UserStatUtil;
import io.netty.channel.ChannelFuture;
import java.arthas.SpyAPI;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ArthasBootstrap {
    public static final String ARTHAS_HOME_PROPERTY = "arthas.home";
    private static String ARTHAS_SHOME = null;
    public static final String CONFIG_NAME_PROPERTY = "arthas.config.name";
    public static final String CONFIG_LOCATION_PROPERTY = "arthas.config.location";
    public static final String CONFIG_OVERRIDE_ALL = "arthas.config.overrideAll";
    private static ArthasBootstrap arthasBootstrap;
    private ArthasEnvironment arthasEnvironment;
    private Configure configure;
    private AtomicBoolean isBindRef = new AtomicBoolean(false);
    private Instrumentation instrumentation;
    private Thread shutdown;
    private ShellServer shellServer;
    private ScheduledExecutorService executorService;
    private TunnelClient tunnelClient;
    private File arthasOutputDir;
    private static LoggerContext loggerContext;
    private Timer timer = new Timer("arthas-timer", true);
    private TransformerManager transformerManager;

    private ArthasBootstrap(Instrumentation instrumentation, String args) throws Throwable {
        this.instrumentation = instrumentation;
        String outputPath = System.getProperty("arthas.output.dir", "arthas-output");
        this.arthasOutputDir = new File(outputPath);
        this.arthasOutputDir.mkdirs();
        ArthasBootstrap.initSpy();
        this.initArthasEnvironment(args);
        loggerContext = LogUtil.initLooger(this.arthasEnvironment);
        this.bind(this.configure);
        this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "as-command-execute-daemon");
                t.setDaemon(true);
                return t;
            }
        });
        this.shutdown = new Thread("as-shutdown-hooker"){

            @Override
            public void run() {
                ArthasBootstrap.this.destroy();
            }
        };
        this.transformerManager = new TransformerManager(instrumentation);
        Runtime.getRuntime().addShutdownHook(this.shutdown);
    }

    private static void initSpy() {
    }

    private void initArthasEnvironment(String args) throws IOException {
        if (this.arthasEnvironment == null) {
            this.arthasEnvironment = new ArthasEnvironment();
        }
        Map<String, String> argsMap = FeatureCodec.DEFAULT_COMMANDLINE_CODEC.toMap(args);
        HashMap<String, Object> mapWithPrefix = new HashMap<String, Object>(argsMap.size());
        for (Map.Entry<String, String> entry : argsMap.entrySet()) {
            mapWithPrefix.put("arthas." + entry.getKey(), entry.getValue());
        }
        mapWithPrefix.put(ARTHAS_HOME_PROPERTY, this.arthasHome());
        MapPropertySource mapPropertySource = new MapPropertySource("args", (Map<String, Object>)mapWithPrefix);
        this.arthasEnvironment.addFirst(mapPropertySource);
        this.tryToLoadArthasProperties();
        this.configure = new Configure();
        BinderUtils.inject(this.arthasEnvironment, this.configure);
    }

    private String arthasHome() {
        if (ARTHAS_SHOME != null) {
            return ARTHAS_SHOME;
        }
        CodeSource codeSource = ArthasBootstrap.class.getProtectionDomain().getCodeSource();
        if (codeSource != null) {
            try {
                ARTHAS_SHOME = new File(codeSource.getLocation().toURI().getSchemeSpecificPart()).getParentFile().getAbsolutePath();
            }
            catch (Throwable e) {
                AnsiLog.error((String)"try to load arthas.properties error", (Object[])new Object[]{e});
            }
        }
        if (ARTHAS_SHOME == null) {
            ARTHAS_SHOME = new File("").getAbsolutePath();
        }
        return ARTHAS_SHOME;
    }

    private void tryToLoadArthasProperties() throws IOException {
        this.arthasEnvironment.resolvePlaceholders(CONFIG_LOCATION_PROPERTY);
        String location = null;
        if (this.arthasEnvironment.containsProperty(CONFIG_LOCATION_PROPERTY)) {
            location = this.arthasEnvironment.resolvePlaceholders(CONFIG_LOCATION_PROPERTY);
        }
        if (location == null) {
            location = this.arthasHome();
        }
        String configName = "arthas";
        if (this.arthasEnvironment.containsProperty(CONFIG_NAME_PROPERTY)) {
            configName = this.arthasEnvironment.resolvePlaceholders(CONFIG_NAME_PROPERTY);
        }
        if (location != null && !location.endsWith(".properties")) {
            location = new File(location, configName + ".properties").getAbsolutePath();
        }
        if (new File(location).exists()) {
            Properties properties = FileUtils.readProperties(location);
            boolean overrideAll = false;
            overrideAll = this.arthasEnvironment.containsProperty(CONFIG_OVERRIDE_ALL) ? this.arthasEnvironment.getRequiredProperty(CONFIG_OVERRIDE_ALL, Boolean.TYPE) : Boolean.parseBoolean(properties.getProperty(CONFIG_OVERRIDE_ALL, "false"));
            PropertiesPropertySource propertySource = new PropertiesPropertySource(location, properties);
            if (overrideAll) {
                this.arthasEnvironment.addFirst(propertySource);
            } else {
                this.arthasEnvironment.addLast(propertySource);
            }
        }
    }

    public void bind(Configure configure) throws Throwable {
        long start = System.currentTimeMillis();
        if (!this.isBindRef.compareAndSet(false, true)) {
            throw new IllegalStateException("already bind");
        }
        String agentId = null;
        try {
            if (configure.getTunnelServer() != null && configure.getHttpPort() > 0) {
                this.tunnelClient = new TunnelClient();
                this.tunnelClient.setId(configure.getAgentId());
                this.tunnelClient.setTunnelServerUrl(configure.getTunnelServer());
                String host = "127.0.0.1";
                if (configure.getIp() != null) {
                    host = configure.getIp();
                }
                URI uri = new URI("ws", null, host, configure.getHttpPort(), "/ws", null, null);
                this.tunnelClient.setLocalServerUrl(uri.toString());
                ChannelFuture channelFuture = this.tunnelClient.start();
                channelFuture.await(10L, TimeUnit.SECONDS);
                if (channelFuture.isSuccess()) {
                    agentId = this.tunnelClient.getId();
                }
            }
        }
        catch (Throwable t) {
            this.logger().error("start tunnel client error", t);
        }
        try {
            ShellServerOptions options = new ShellServerOptions().setInstrumentation(this.instrumentation).setPid(PidUtils.currentLongPid()).setSessionTimeout(configure.getSessionTimeout() * 1000L);
            if (agentId != null) {
                HashMap<String, String> welcomeInfos = new HashMap<String, String>();
                welcomeInfos.put("id", agentId);
                options.setWelcomeMessage(ArthasBanner.welcome(welcomeInfos));
            }
            this.shellServer = new ShellServerImpl(options, this);
            BuiltinCommandPack builtinCommands = new BuiltinCommandPack();
            ArrayList<BuiltinCommandPack> resolvers = new ArrayList<BuiltinCommandPack>();
            resolvers.add(builtinCommands);
            if (configure.getTelnetPort() > 0) {
                this.shellServer.registerTermServer(new HttpTelnetTermServer(configure.getIp(), configure.getTelnetPort(), options.getConnectionTimeout()));
            } else {
                this.logger().info("telnet port is {}, skip bind telnet server.", (Object)configure.getTelnetPort());
            }
            if (configure.getHttpPort() > 0) {
                this.shellServer.registerTermServer(new HttpTermServer(configure.getIp(), configure.getHttpPort(), options.getConnectionTimeout()));
            } else {
                this.logger().info("http port is {}, skip bind http server.", (Object)configure.getHttpPort());
            }
            for (CommandResolver commandResolver : resolvers) {
                this.shellServer.registerCommandResolver(commandResolver);
            }
            this.shellServer.listen(new BindHandler(this.isBindRef));
            this.logger().info("as-server listening on network={};telnet={};http={};timeout={};", new Object[]{configure.getIp(), configure.getTelnetPort(), configure.getHttpPort(), options.getConnectionTimeout()});
            if (configure.getStatUrl() != null) {
                this.logger().info("arthas stat url: {}", (Object)configure.getStatUrl());
            }
            UserStatUtil.setStatUrl(configure.getStatUrl());
            UserStatUtil.arthasStart();
            this.logger().info("as-server started in {} ms", (Object)(System.currentTimeMillis() - start));
        }
        catch (Throwable e) {
            this.logger().error("Error during bind to port " + configure.getTelnetPort(), e);
            if (this.shellServer != null) {
                this.shellServer.close();
            }
            throw e;
        }
    }

    public boolean isBind() {
        return this.isBindRef.get();
    }

    public void destroy() {
        this.timer.cancel();
        if (this.tunnelClient != null) {
            try {
                this.tunnelClient.stop();
            }
            catch (Throwable e) {
                this.logger().error("arthas", (Object)"stop tunnel client error", (Object)e);
            }
        }
        this.executorService.shutdownNow();
        this.transformerManager.destroy();
        UserStatUtil.destroy();
        this.cleanUpSpyReference();
        try {
            Runtime.getRuntime().removeShutdownHook(this.shutdown);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.logger().info("as-server destroy completed.");
        if (loggerContext != null) {
            loggerContext.stop();
        }
    }

    public static synchronized ArthasBootstrap getInstance(Instrumentation instrumentation, String args) throws Throwable {
        if (arthasBootstrap == null) {
            arthasBootstrap = new ArthasBootstrap(instrumentation, args);
        }
        return arthasBootstrap;
    }

    public static ArthasBootstrap getInstance() {
        if (arthasBootstrap == null) {
            throw new IllegalStateException("ArthasBootstrap must be initialized before!");
        }
        return arthasBootstrap;
    }

    public void execute(Runnable command) {
        this.executorService.execute(command);
    }

    private void cleanUpSpyReference() {
        SpyAPI.setNopSpy();
        try {
            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("com.taobao.arthas.agent332.AgentBootstrap");
            Method method = clazz.getDeclaredMethod("resetArthasClassLoader", new Class[0]);
            method.invoke(null, new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public TunnelClient getTunnelClient() {
        return this.tunnelClient;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.executorService;
    }

    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public TransformerManager getTransformerManager() {
        return this.transformerManager;
    }

    private Logger logger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

