/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util.affect;

import com.taobao.arthas.core.GlobalOptions;
import com.taobao.arthas.core.util.ClassLoaderUtils;
import com.taobao.arthas.core.util.affect.Affect;
import java.io.File;
import java.lang.instrument.ClassFileTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public final class EnhancerAffect
extends Affect {
    private final AtomicInteger cCnt = new AtomicInteger();
    private final AtomicInteger mCnt = new AtomicInteger();
    private ClassFileTransformer transformer;
    private long listenerId;
    private Throwable throwable;
    private final Collection<File> classDumpFiles = new ArrayList<File>();
    private final List<String> methods = new ArrayList<String>();

    public int cCnt(int cc) {
        return this.cCnt.addAndGet(cc);
    }

    public int mCnt(int mc) {
        return this.mCnt.addAndGet(mc);
    }

    public int addMethodAndCount(ClassLoader classLoader, String clazz, String method, String methodDesc) {
        this.methods.add(ClassLoaderUtils.classLoaderHash(classLoader) + "|" + clazz.replace('/', '.') + "#" + method + "|" + methodDesc);
        return this.mCnt.addAndGet(1);
    }

    public int cCnt() {
        return this.cCnt.get();
    }

    public int mCnt() {
        return this.mCnt.get();
    }

    public void addClassDumpFile(File file) {
        this.classDumpFiles.add(file);
    }

    public ClassFileTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(ClassFileTransformer transformer) {
        this.transformer = transformer;
    }

    public long getListenerId() {
        return this.listenerId;
    }

    public void setListenerId(long listenerId) {
        this.listenerId = listenerId;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    @Override
    public String toString() {
        StringBuilder infoSB = new StringBuilder();
        if (GlobalOptions.isDump && !this.classDumpFiles.isEmpty()) {
            for (File classDumpFile : this.classDumpFiles) {
                infoSB.append("[dump: ").append(classDumpFile.getAbsoluteFile()).append("]\n");
            }
        }
        if (GlobalOptions.verbose && !this.methods.isEmpty()) {
            for (String method : this.methods) {
                infoSB.append("[Affect method: ").append(method).append("]\n");
            }
        }
        infoSB.append(String.format("Affect(class count: %d , method count: %d) cost in %s ms, listenerId: %d", this.cCnt(), this.mCnt(), this.cost(), this.listenerId));
        if (this.throwable != null) {
            infoSB.append("\nEnhance error! exception: " + this.throwable);
        }
        return infoSB.toString();
    }
}

