/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.system.impl;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.GlobalOptions;
import com.taobao.arthas.core.server.ArthasBootstrap;
import com.taobao.arthas.core.shell.cli.CliToken;
import com.taobao.arthas.core.shell.handlers.Handler;
import com.taobao.arthas.core.shell.impl.ShellImpl;
import com.taobao.arthas.core.shell.system.Job;
import com.taobao.arthas.core.shell.system.impl.InternalCommandManager;
import com.taobao.arthas.core.shell.system.impl.JobControllerImpl;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GlobalJobControllerImpl
extends JobControllerImpl {
    private Map<Integer, JobTimeoutTask> jobTimeoutTaskMap = new HashMap<Integer, JobTimeoutTask>();
    private static final Logger logger = LoggerFactory.getLogger(GlobalJobControllerImpl.class);

    @Override
    public void close(Handler<Void> completionHandler) {
        if (completionHandler != null) {
            completionHandler.handle(null);
        }
    }

    @Override
    public void close() {
        this.jobTimeoutTaskMap.clear();
        for (Job job : this.jobs()) {
            job.terminate();
        }
    }

    @Override
    public boolean removeJob(int id) {
        JobTimeoutTask jobTimeoutTask = this.jobTimeoutTaskMap.remove(id);
        if (jobTimeoutTask != null) {
            jobTimeoutTask.cancel();
        }
        return super.removeJob(id);
    }

    @Override
    public Job createJob(InternalCommandManager commandManager, List<CliToken> tokens, ShellImpl shell) {
        Job job = super.createJob(commandManager, tokens, shell);
        JobTimeoutTask jobTimeoutTask = new JobTimeoutTask(job);
        long jobTimeoutInSecond = this.getJobTimeoutInSecond();
        Date timeoutDate = new Date(System.currentTimeMillis() + jobTimeoutInSecond * 1000L);
        ArthasBootstrap.getInstance().getScheduledExecutorService().schedule(jobTimeoutTask, jobTimeoutInSecond, TimeUnit.SECONDS);
        this.jobTimeoutTaskMap.put(job.id(), jobTimeoutTask);
        job.setTimeoutDate(timeoutDate);
        return job;
    }

    private long getJobTimeoutInSecond() {
        long result = -1L;
        String jobTimeoutConfig = GlobalOptions.jobTimeout.trim();
        try {
            char unit = jobTimeoutConfig.charAt(jobTimeoutConfig.length() - 1);
            String duration = jobTimeoutConfig.substring(0, jobTimeoutConfig.length() - 1);
            switch (unit) {
                case 'h': {
                    result = TimeUnit.HOURS.toSeconds(Long.parseLong(duration));
                    break;
                }
                case 'd': {
                    result = TimeUnit.DAYS.toSeconds(Long.parseLong(duration));
                    break;
                }
                case 'm': {
                    result = TimeUnit.MINUTES.toSeconds(Long.parseLong(duration));
                    break;
                }
                case 's': {
                    result = Long.parseLong(duration);
                    break;
                }
                default: {
                    result = Long.parseLong(jobTimeoutConfig);
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result < 0L) {
            result = TimeUnit.DAYS.toSeconds(1L);
            logger.warn("Configuration with job timeout " + jobTimeoutConfig + " is error, use 1d in default.");
        }
        return result;
    }

    private static class JobTimeoutTask
    implements Runnable {
        private Job job;

        public JobTimeoutTask(Job job) {
            this.job = job;
        }

        @Override
        public void run() {
            try {
                if (this.job != null) {
                    Job temp = this.job;
                    this.job = null;
                    temp.terminate();
                }
            }
            catch (Throwable e) {
                try {
                    logger.error("JobTimeoutTask error, job id: {}, line: {}", new Object[]{this.job.id(), this.job.line(), e});
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public void cancel() {
            this.job = null;
        }
    }
}

