/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.impl;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.server.ArthasBootstrap;
import com.taobao.arthas.core.shell.Shell;
import com.taobao.arthas.core.shell.ShellServer;
import com.taobao.arthas.core.shell.ShellServerOptions;
import com.taobao.arthas.core.shell.command.CommandResolver;
import com.taobao.arthas.core.shell.future.Future;
import com.taobao.arthas.core.shell.handlers.Handler;
import com.taobao.arthas.core.shell.handlers.server.SessionClosedHandler;
import com.taobao.arthas.core.shell.handlers.server.SessionsClosedHandler;
import com.taobao.arthas.core.shell.handlers.server.TermServerListenHandler;
import com.taobao.arthas.core.shell.handlers.server.TermServerTermHandler;
import com.taobao.arthas.core.shell.impl.BuiltinCommandResolver;
import com.taobao.arthas.core.shell.impl.ShellImpl;
import com.taobao.arthas.core.shell.system.Job;
import com.taobao.arthas.core.shell.system.impl.GlobalJobControllerImpl;
import com.taobao.arthas.core.shell.system.impl.InternalCommandManager;
import com.taobao.arthas.core.shell.system.impl.JobControllerImpl;
import com.taobao.arthas.core.shell.term.Term;
import com.taobao.arthas.core.shell.term.TermServer;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ShellServerImpl
extends ShellServer {
    private static final Logger logger = LoggerFactory.getLogger(ShellServerImpl.class);
    private final CopyOnWriteArrayList<CommandResolver> resolvers;
    private final InternalCommandManager commandManager;
    private final List<TermServer> termServers;
    private final long timeoutMillis;
    private final long reaperInterval;
    private String welcomeMessage;
    private ArthasBootstrap bootstrap;
    private Instrumentation instrumentation;
    private long pid;
    private boolean closed = true;
    private final Map<String, ShellImpl> sessions;
    private final Future<Void> sessionsClosed = Future.future();
    private ScheduledExecutorService scheduledExecutorService;
    private JobControllerImpl jobController = new GlobalJobControllerImpl();

    public ShellServerImpl(ShellServerOptions options) {
        this(options, null);
    }

    public ShellServerImpl(ShellServerOptions options, ArthasBootstrap bootstrap) {
        this.welcomeMessage = options.getWelcomeMessage();
        this.termServers = new ArrayList<TermServer>();
        this.timeoutMillis = options.getSessionTimeout();
        this.sessions = new ConcurrentHashMap<String, ShellImpl>();
        this.reaperInterval = options.getReaperInterval();
        this.resolvers = new CopyOnWriteArrayList();
        this.commandManager = new InternalCommandManager(this.resolvers);
        this.instrumentation = options.getInstrumentation();
        this.bootstrap = bootstrap;
        this.pid = options.getPid();
        this.resolvers.add(new BuiltinCommandResolver());
    }

    @Override
    public synchronized ShellServer registerCommandResolver(CommandResolver resolver) {
        this.resolvers.add(0, resolver);
        return this;
    }

    @Override
    public synchronized ShellServer registerTermServer(TermServer termServer) {
        this.termServers.add(termServer);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTerm(Term term) {
        ShellServerImpl shellServerImpl = this;
        synchronized (shellServerImpl) {
            if (this.closed) {
                term.close();
                return;
            }
        }
        ShellImpl session = this.createShell(term);
        session.setWelcome(this.welcomeMessage);
        session.closedFuture.setHandler(new SessionClosedHandler(this, session));
        session.init();
        this.sessions.put(session.id, session);
        session.readline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ShellServer listen(Handler<Future<Void>> listenHandler) {
        List<TermServer> toStart;
        ShellServerImpl shellServerImpl = this;
        synchronized (shellServerImpl) {
            if (!this.closed) {
                throw new IllegalStateException("Server listening");
            }
            toStart = this.termServers;
        }
        AtomicInteger count = new AtomicInteger(toStart.size());
        if (count.get() == 0) {
            this.setClosed(false);
            listenHandler.handle(Future.succeededFuture());
            return this;
        }
        TermServerListenHandler handler = new TermServerListenHandler(this, listenHandler, toStart);
        for (TermServer termServer : toStart) {
            termServer.termHandler(new TermServerTermHandler(this));
            termServer.listen(handler);
        }
        return this;
    }

    private void evictSessions() {
        long now = System.currentTimeMillis();
        HashSet<ShellImpl> toClose = new HashSet<ShellImpl>();
        for (ShellImpl session : this.sessions.values()) {
            if (now - session.lastAccessedTime() > this.timeoutMillis && session.jobs().size() == 0) {
                toClose.add(session);
            }
            logger.debug(session.id + ":" + session.lastAccessedTime());
        }
        for (ShellImpl session : toClose) {
            long timeOutInMinutes = this.timeoutMillis / 1000L / 60L;
            String reason = "session is inactive for " + timeOutInMinutes + " min(s).";
            session.close(reason);
        }
    }

    public synchronized void setTimer() {
        if (!this.closed && this.reaperInterval > 0L) {
            this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r, "arthas-shell-server");
                    return t;
                }
            });
            this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    ShellServerImpl.this.evictSessions();
                }
            }, 0L, this.reaperInterval, TimeUnit.MILLISECONDS);
        }
    }

    public synchronized void setClosed(boolean closed) {
        this.closed = closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(ShellImpl shell) {
        boolean completeSessionClosed;
        Job job = shell.getForegroundJob();
        if (job != null) {
            job.terminate();
            logger.info("Session {} closed, so terminate foreground job, id: {}, line: {}", new Object[]{shell.session().getSessionId(), job.id(), job.line()});
        }
        ShellServerImpl shellServerImpl = this;
        synchronized (shellServerImpl) {
            this.sessions.remove(shell.id);
            shell.close("network error");
            completeSessionClosed = this.sessions.isEmpty() && this.closed;
        }
        if (completeSessionClosed) {
            this.sessionsClosed.complete();
        }
    }

    @Override
    public synchronized Shell createShell() {
        return this.createShell(null);
    }

    @Override
    public synchronized ShellImpl createShell(Term term) {
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        return new ShellImpl(this, term, this.commandManager, this.instrumentation, this.pid, this.jobController);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Handler<Future<Void>> completionHandler) {
        List<ShellImpl> toClose;
        List<Object> toStop;
        ShellServerImpl shellServerImpl = this;
        synchronized (shellServerImpl) {
            if (this.closed) {
                toStop = Collections.emptyList();
                toClose = Collections.emptyList();
            } else {
                this.setClosed(true);
                if (this.scheduledExecutorService != null) {
                    this.scheduledExecutorService.shutdownNow();
                }
                toStop = this.termServers;
                toClose = new ArrayList<ShellImpl>(this.sessions.values());
                if (toClose.isEmpty()) {
                    this.sessionsClosed.complete();
                }
            }
        }
        if (toStop.isEmpty() && toClose.isEmpty()) {
            completionHandler.handle(Future.succeededFuture());
        } else {
            AtomicInteger count = new AtomicInteger(1 + toClose.size());
            SessionsClosedHandler handler = new SessionsClosedHandler(count, completionHandler);
            for (ShellImpl shellImpl : toClose) {
                shellImpl.close("server is going to shutdown.");
            }
            for (TermServer termServer : toStop) {
                termServer.close(handler);
            }
            this.jobController.close();
            this.sessionsClosed.setHandler(handler);
            this.bootstrap.destroy();
        }
    }
}

