/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.advisor.Advice;
import com.taobao.arthas.core.advisor.AdviceListenerAdapter;
import com.taobao.arthas.core.advisor.ArthasMethod;
import com.taobao.arthas.core.command.monitor200.StackCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.DateUtils;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.arthas.core.util.ThreadLocalWatch;
import com.taobao.arthas.core.util.ThreadUtil;

public class StackAdviceListener
extends AdviceListenerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(StackAdviceListener.class);
    private final ThreadLocal<String> stackThreadLocal = new ThreadLocal();
    private final ThreadLocalWatch threadLocalWatch = new ThreadLocalWatch();
    private StackCommand command;
    private CommandProcess process;

    public StackAdviceListener(StackCommand command, CommandProcess process) {
        this.command = command;
        this.process = process;
    }

    @Override
    public void before(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args) throws Throwable {
        this.stackThreadLocal.set(ThreadUtil.getThreadStack(Thread.currentThread()));
        this.threadLocalWatch.start();
    }

    @Override
    public void afterThrowing(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args, Throwable throwable) throws Throwable {
        Advice advice = Advice.newForAfterThrowing(loader, clazz, method, target, args, throwable);
        this.finishing(advice);
    }

    @Override
    public void afterReturning(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args, Object returnObject) throws Throwable {
        Advice advice = Advice.newForAfterRetuning(loader, clazz, method, target, args, returnObject);
        this.finishing(advice);
    }

    private void finishing(Advice advice) {
        try {
            double cost = this.threadLocalWatch.costInMillis();
            if (this.isConditionMet(this.command.getConditionExpress(), advice, cost)) {
                this.process.write("ts=" + DateUtils.getCurrentDate() + ";" + this.stackThreadLocal.get() + "\n");
                this.process.times().incrementAndGet();
                if (this.isLimitExceeded(this.command.getNumberOfLimit(), this.process.times().get())) {
                    this.abortProcess(this.process, this.command.getNumberOfLimit());
                }
            }
        }
        catch (Exception e) {
            logger.warn("stack failed.", (Throwable)e);
            this.process.write("stack failed, condition is: " + this.command.getConditionExpress() + ", " + e.getMessage() + ", visit " + LogUtil.loggingFile() + " for more details.\n");
            this.process.end();
        }
    }
}

