/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.basic1000;

import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.Command;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.shell.command.CommandResolver;
import com.taobao.arthas.core.shell.session.Session;
import com.taobao.arthas.core.util.usage.StyledUsageFormatter;
import com.taobao.middleware.cli.CLI;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Summary;
import com.taobao.text.Color;
import com.taobao.text.Decoration;
import com.taobao.text.Style;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.LabelElement;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.util.ArrayList;
import java.util.List;

@Name(value="help")
@Summary(value="Display Arthas Help")
@Description(value="Examples:\n help\n help sc\n help sm\n help watch")
public class HelpCommand
extends AnnotatedCommand {
    private String cmd;

    @Argument(index=0, argName="cmd", required=false)
    @Description(value="command name")
    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    @Override
    public void process(CommandProcess process) {
        List<Command> commands = this.allCommands(process.session());
        Command targetCmd = this.findCommand(commands);
        String message = targetCmd == null ? RenderUtil.render((Element)HelpCommand.mainHelp(commands), (int)process.width()) : HelpCommand.commandHelp(targetCmd, process.width());
        process.write(message);
        process.end();
    }

    @Override
    public void complete(Completion completion) {
        List<Command> commands = this.allCommands(completion.session());
        ArrayList<String> names = new ArrayList<String>(commands.size());
        for (Command command : commands) {
            CLI cli = command.cli();
            if (cli == null || cli.isHidden()) continue;
            names.add(command.name());
        }
        CompletionUtils.complete(completion, names);
    }

    private static String commandHelp(Command command, int width) {
        return StyledUsageFormatter.styledUsage(command.cli(), width);
    }

    private static Element mainHelp(List<Command> commands) {
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        table.row(new Element[]{new LabelElement("NAME").style(Style.style((Decoration)Decoration.bold)), new LabelElement("DESCRIPTION")});
        for (Command command : commands) {
            CLI cli = command.cli();
            if (cli == null || cli.isHidden()) continue;
            table.add(Element.row().add(new Element[]{Element.label((String)cli.getName()).style(Style.style((Color)Color.green))}).add(new Element[]{Element.label((String)cli.getSummary())}));
        }
        return table;
    }

    private List<Command> allCommands(Session session) {
        List<CommandResolver> commandResolvers = session.getCommandResolvers();
        ArrayList<Command> commands = new ArrayList<Command>();
        for (CommandResolver commandResolver : commandResolvers) {
            commands.addAll(commandResolver.commands());
        }
        return commands;
    }

    private Command findCommand(List<Command> commands) {
        for (Command command : commands) {
            if (!command.name().equals(this.cmd)) continue;
            return command;
        }
        return null;
    }
}

