/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.basic1000;

import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.DefaultValue;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;

@Name(value="grep")
@Summary(value="grep command for pipes.")
@Description(value="\nEXAMPLES:\n sysprop | grep java \n sysprop | grep java -n\n sysenv | grep -v JAVA\n sysenv | grep -e \"(?i)(JAVA|sun)\" -m 3  -C 2\n sysenv | grep JAVA -A2 -B3\n thread | grep -m 10 -e  \"TIMED_WAITING|WAITING\"\n\nWIKI:\n  https://alibaba.github.io/arthas/grep")
public class GrepCommand
extends AnnotatedCommand {
    private String pattern;
    private boolean ignoreCase;
    private boolean invertMatch;
    private boolean isRegEx = false;
    private boolean showLineNumber = false;
    private boolean trimEnd;
    private int beforeLines;
    private int afterLines;
    private int context;
    private int maxCount;

    @Argument(index=0, argName="pattern", required=true)
    @Description(value="Pattern")
    public void setOptionName(String pattern) {
        this.pattern = pattern;
    }

    @Option(shortName="e", longName="regex", flag=true)
    @Description(value="Enable regular expression to match")
    public void setRegEx(boolean regEx) {
        this.isRegEx = regEx;
    }

    @Option(shortName="i", longName="ignore-case", flag=true)
    @Description(value="Perform case insensitive matching.  By default, grep is case sensitive.")
    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    @Option(shortName="v", longName="invert-match", flag=true)
    @Description(value="Select non-matching lines")
    public void setInvertMatch(boolean invertMatch) {
        this.invertMatch = invertMatch;
    }

    @Option(shortName="n", longName="line-number", flag=true)
    @Description(value="Print line number with output lines")
    public void setShowLineNumber(boolean showLineNumber) {
        this.showLineNumber = showLineNumber;
    }

    @Option(longName="trim-end", flag=false)
    @DefaultValue(value="true")
    @Description(value="Remove whitespaces at the end of the line, default value true")
    public void setTrimEnd(boolean trimEnd) {
        this.trimEnd = trimEnd;
    }

    @Option(shortName="B", longName="before-context")
    @Description(value="Print NUM lines of leading context)")
    public void setBeforeLines(int beforeLines) {
        this.beforeLines = beforeLines;
    }

    @Option(shortName="A", longName="after-context")
    @Description(value="Print NUM lines of trailing context)")
    public void setAfterLines(int afterLines) {
        this.afterLines = afterLines;
    }

    @Option(shortName="C", longName="context")
    @Description(value="Print NUM lines of output context)")
    public void setContext(int context) {
        this.context = context;
    }

    @Option(shortName="m", longName="max-count")
    @Description(value="stop after NUM selected lines)")
    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public boolean isInvertMatch() {
        return this.invertMatch;
    }

    public boolean isRegEx() {
        return this.isRegEx;
    }

    public boolean isShowLineNumber() {
        return this.showLineNumber;
    }

    public boolean isTrimEnd() {
        return this.trimEnd;
    }

    public int getBeforeLines() {
        return this.beforeLines;
    }

    public int getAfterLines() {
        return this.afterLines;
    }

    public int getContext() {
        return this.context;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    @Override
    public void process(CommandProcess process) {
        process.write("The grep command only for pipes. See 'grep --help'\n");
        process.end();
    }
}

