/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.advisor;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.common.concurrent.ConcurrentWeakKeyHashMap;
import com.taobao.arthas.core.advisor.AdviceListener;
import com.taobao.arthas.core.server.ArthasBootstrap;
import com.taobao.arthas.core.shell.system.ExecStatus;
import com.taobao.arthas.core.shell.system.Process;
import com.taobao.arthas.core.shell.system.ProcessAware;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class AdviceListenerManager {
    private static final Logger logger = LoggerFactory.getLogger(AdviceListenerManager.class);
    private static final FakeBootstrapClassLoader FAKEBOOTSTRAPCLASSLOADER = new FakeBootstrapClassLoader();
    private static ConcurrentWeakKeyHashMap<ClassLoader, ClassLoaderAdviceListenerManager> adviceListenerMap;

    public static void registerAdviceListener(ClassLoader classLoader, String className, String methodName, String methodDesc, AdviceListener listener) {
        classLoader = AdviceListenerManager.wrap(classLoader);
        className = className.replace('/', '.');
        ClassLoaderAdviceListenerManager manager = (ClassLoaderAdviceListenerManager)adviceListenerMap.get((Object)classLoader);
        if (manager == null) {
            manager = new ClassLoaderAdviceListenerManager();
            adviceListenerMap.put((Object)classLoader, (Object)manager);
        }
        manager.registerAdviceListener(className, methodName, methodDesc, listener);
    }

    public static void updateAdviceListeners() {
    }

    public static List<AdviceListener> queryAdviceListeners(ClassLoader classLoader, String className, String methodName, String methodDesc) {
        classLoader = AdviceListenerManager.wrap(classLoader);
        className = className.replace('/', '.');
        ClassLoaderAdviceListenerManager manager = (ClassLoaderAdviceListenerManager)adviceListenerMap.get((Object)classLoader);
        if (manager != null) {
            return manager.queryAdviceListeners(className, methodName, methodDesc);
        }
        return null;
    }

    public static void registerTraceAdviceListener(ClassLoader classLoader, String className, String owner, String methodName, String methodDesc, AdviceListener listener) {
        classLoader = AdviceListenerManager.wrap(classLoader);
        className = className.replace('/', '.');
        ClassLoaderAdviceListenerManager manager = (ClassLoaderAdviceListenerManager)adviceListenerMap.get((Object)classLoader);
        if (manager == null) {
            manager = new ClassLoaderAdviceListenerManager();
            adviceListenerMap.put((Object)classLoader, (Object)manager);
        }
        manager.registerTraceAdviceListener(className, owner, methodName, methodDesc, listener);
    }

    public static List<AdviceListener> queryTraceAdviceListeners(ClassLoader classLoader, String className, String owner, String methodName, String methodDesc) {
        classLoader = AdviceListenerManager.wrap(classLoader);
        className = className.replace('/', '.');
        ClassLoaderAdviceListenerManager manager = (ClassLoaderAdviceListenerManager)adviceListenerMap.get((Object)classLoader);
        if (manager != null) {
            return manager.queryTraceAdviceListeners(className, owner, methodName, methodDesc);
        }
        return null;
    }

    private static ClassLoader wrap(ClassLoader classLoader) {
        if (classLoader != null) {
            return classLoader;
        }
        return FAKEBOOTSTRAPCLASSLOADER;
    }

    static {
        ArthasBootstrap.getInstance().getScheduledExecutorService().scheduleWithFixedDelay(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    if (adviceListenerMap == null) return;
                    Iterator iterator = adviceListenerMap.entrySet().iterator();
                    block6: while (true) {
                        ClassLoaderAdviceListenerManager adviceListenerManager;
                        if (!iterator.hasNext()) return;
                        Map.Entry entry = (Map.Entry)iterator.next();
                        ClassLoaderAdviceListenerManager classLoaderAdviceListenerManager = adviceListenerManager = (ClassLoaderAdviceListenerManager)entry.getValue();
                        synchronized (classLoaderAdviceListenerManager) {
                            Iterator iterator2 = adviceListenerManager.map.entrySet().iterator();
                            while (true) {
                                Iterator iterator3;
                                ArrayList<AdviceListener> newResult;
                                List listeners;
                                Map.Entry eee;
                                if (iterator2.hasNext()) {
                                    eee = iterator2.next();
                                    listeners = (List)eee.getValue();
                                    newResult = new ArrayList<AdviceListener>();
                                    iterator3 = listeners.iterator();
                                } else {
                                    continue block6;
                                }
                                while (iterator3.hasNext()) {
                                    ExecStatus status;
                                    ProcessAware processAware;
                                    Process process;
                                    AdviceListener listener = (AdviceListener)iterator3.next();
                                    if (!(listener instanceof ProcessAware) || (process = (processAware = (ProcessAware)((Object)listener)).getProcess()) == null || (status = process.status()).equals((Object)ExecStatus.TERMINATED)) continue;
                                    newResult.add(listener);
                                }
                                if (newResult.size() == listeners.size()) continue;
                                adviceListenerManager.map.put(eee.getKey(), newResult);
                            }
                        }
                        break;
                    }
                }
                catch (Throwable e) {
                    try {
                        logger.error("clean AdviceListener error", e);
                        return;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }, 3L, 3L, TimeUnit.SECONDS);
        adviceListenerMap = new ConcurrentWeakKeyHashMap();
    }

    private static class FakeBootstrapClassLoader
    extends ClassLoader {
        private FakeBootstrapClassLoader() {
        }
    }

    static class ClassLoaderAdviceListenerManager {
        private ConcurrentHashMap<String, List<AdviceListener>> map = new ConcurrentHashMap();

        ClassLoaderAdviceListenerManager() {
        }

        private String key(String className, String methodName, String methodDesc) {
            return className + methodName + methodDesc;
        }

        private String keyForTrace(String className, String owner, String methodName, String methodDesc) {
            return className + owner + methodName + methodDesc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerAdviceListener(String className, String methodName, String methodDesc, AdviceListener listener) {
            ClassLoaderAdviceListenerManager classLoaderAdviceListenerManager = this;
            synchronized (classLoaderAdviceListenerManager) {
                className = className.replace('/', '.');
                String key = this.key(className, methodName, methodDesc);
                List<AdviceListener> listeners = this.map.get(key);
                if (listeners == null) {
                    listeners = new ArrayList<AdviceListener>();
                    this.map.put(key, listeners);
                }
                if (!listeners.contains(listener)) {
                    listeners.add(listener);
                }
            }
        }

        public List<AdviceListener> queryAdviceListeners(String className, String methodName, String methodDesc) {
            className = className.replace('/', '.');
            String key = this.key(className, methodName, methodDesc);
            List<AdviceListener> listeners = this.map.get(key);
            return listeners;
        }

        public void registerTraceAdviceListener(String className, String owner, String methodName, String methodDesc, AdviceListener listener) {
            String key = this.keyForTrace(className = className.replace('/', '.'), owner, methodName, methodDesc);
            List<AdviceListener> listeners = this.map.get(key);
            if (listeners == null) {
                listeners = new ArrayList<AdviceListener>();
                this.map.put(key, listeners);
            }
            if (!listeners.contains(listener)) {
                listeners.add(listener);
            }
        }

        public List<AdviceListener> queryTraceAdviceListeners(String className, String owner, String methodName, String methodDesc) {
            className = className.replace('/', '.');
            String key = this.keyForTrace(className, owner, methodName, methodDesc);
            List<AdviceListener> listeners = this.map.get(key);
            return listeners;
        }
    }
}

