/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.ArrayUtils;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.util.ThreadUtil;
import com.taobao.arthas.core.util.affect.RowAffect;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import com.taobao.text.Renderer;
import com.taobao.text.renderers.ThreadRenderer;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.LabelElement;
import com.taobao.text.util.RenderUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Name(value="thread")
@Summary(value="Display thread info, thread stack")
@Description(value="\nEXAMPLES:\n  thread\n  thread 51\n  thread -n -1\n  thread -n 5\n  thread -b\n  thread -i 2000\n  thread --state BLOCKED\n\nWIKI:\n  https://alibaba.github.io/arthas/thread")
public class ThreadCommand
extends AnnotatedCommand {
    private static Set<String> states = null;
    private static ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private long id = -1L;
    private Integer topNBusy = null;
    private boolean findMostBlockingThread = false;
    private int sampleInterval = 100;
    private String state;

    public ThreadCommand() {
        states = new HashSet<String>(Thread.State.values().length);
        for (Thread.State state : Thread.State.values()) {
            states.add(state.name());
        }
    }

    @Argument(index=0, required=false, argName="id")
    @Description(value="Show thread stack")
    public void setId(long id) {
        this.id = id;
    }

    @Option(shortName="n", longName="top-n-threads")
    @Description(value="The number of thread(s) to show, ordered by cpu utilization, -1 to show all.")
    public void setTopNBusy(Integer topNBusy) {
        this.topNBusy = topNBusy;
    }

    @Option(shortName="b", longName="include-blocking-thread", flag=true)
    @Description(value="Find the thread who is holding a lock that blocks the most number of threads.")
    public void setFindMostBlockingThread(boolean findMostBlockingThread) {
        this.findMostBlockingThread = findMostBlockingThread;
    }

    @Option(shortName="i", longName="sample-interval")
    @Description(value="Specify the sampling interval (in ms) when calculating cpu usage.")
    public void setSampleInterval(int sampleInterval) {
        this.sampleInterval = sampleInterval;
    }

    @Option(longName="state")
    @Description(value="Display the thead filter by the state. NEW, RUNNABLE, TIMED_WAITING, WAITING, BLOCKED, TERMINATED is optional.")
    public void setState(String state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(CommandProcess process) {
        RowAffect affect = new RowAffect();
        int status = 0;
        try {
            status = this.id > 0L ? this.processThread(process) : (this.topNBusy != null ? this.processTopBusyThreads(process) : (this.findMostBlockingThread ? this.processBlockingThread(process) : this.processAllThreads(process)));
        }
        finally {
            process.write(affect + "\n");
            process.end(status);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int processAllThreads(CommandProcess process) {
        int status = 0;
        Map<String, Thread> threads = ThreadUtil.getThreads();
        StringBuilder threadStat = new StringBuilder();
        HashMap<Thread.State, Integer> stateCountMap = new HashMap<Thread.State, Integer>();
        for (Thread.State state : Thread.State.values()) {
            stateCountMap.put(state, 0);
        }
        for (Thread thread : threads.values()) {
            Thread.State threadState = thread.getState();
            Integer n = (Integer)stateCountMap.get((Object)threadState);
            stateCountMap.put(threadState, n + 1);
        }
        threadStat.append("Threads Total: ").append(threads.values().size());
        for (Thread.State state : Thread.State.values()) {
            Integer count = (Integer)stateCountMap.get((Object)state);
            threadStat.append(", ").append(state.name()).append(": ").append(count);
        }
        String stat = RenderUtil.render((Element)new LabelElement((Object)threadStat), (int)process.width());
        Collection<Object> resultThreads = new ArrayList();
        if (!StringUtils.isEmpty(this.state)) {
            this.state = this.state.toUpperCase();
            if (!states.contains(this.state)) {
                process.write("Illegal argument, state should be one of " + states + "\n");
                return 1;
            }
            for (Thread thread : threads.values()) {
                if (!this.state.equals(thread.getState().name())) continue;
                resultThreads.add(thread);
            }
        } else {
            resultThreads = threads.values();
        }
        String content = RenderUtil.render(resultThreads.iterator(), (Renderer)new ThreadRenderer((long)this.sampleInterval), (int)process.width());
        process.write(stat + content);
        return status;
    }

    private int processBlockingThread(CommandProcess process) {
        int status = 0;
        ThreadUtil.BlockingLockInfo blockingLockInfo = ThreadUtil.findMostBlockingLock();
        if (blockingLockInfo.threadInfo == null) {
            process.write("No most blocking thread found!\n");
            status = 1;
        } else {
            String stacktrace = ThreadUtil.getFullStacktrace(blockingLockInfo);
            process.write(stacktrace);
        }
        return status;
    }

    private int processTopBusyThreads(CommandProcess process) {
        int status = 0;
        Map<Long, Long> topNThreads = ThreadUtil.getTopNThreads(this.sampleInterval, this.topNBusy);
        Long[] tids = topNThreads.keySet().toArray(new Long[0]);
        ThreadInfo[] threadInfos = threadMXBean.getThreadInfo(ArrayUtils.toPrimitive(tids), true, true);
        if (threadInfos == null) {
            process.write("thread do not exist! id: " + this.id + "\n");
            status = 1;
        } else {
            for (ThreadInfo info : threadInfos) {
                String stacktrace = ThreadUtil.getFullStacktrace(info, topNThreads.get(info.getThreadId()));
                process.write(stacktrace + "\n");
            }
        }
        return status;
    }

    private int processThread(CommandProcess process) {
        String content;
        int status = 0;
        ThreadInfo[] threadInfos = threadMXBean.getThreadInfo(new long[]{this.id}, true, true);
        if (threadInfos == null || threadInfos[0] == null) {
            content = "thread do not exist! id: " + this.id + "\n";
            status = 1;
        } else {
            content = ThreadUtil.getFullStacktrace(threadInfos[0], -1L);
        }
        process.write(content);
        return status;
    }
}

