/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.term.impl.httptelnet;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.shell.future.Future;
import com.taobao.arthas.core.shell.handlers.Handler;
import com.taobao.arthas.core.shell.term.Term;
import com.taobao.arthas.core.shell.term.TermServer;
import com.taobao.arthas.core.shell.term.impl.Helper;
import com.taobao.arthas.core.shell.term.impl.TermImpl;
import com.taobao.arthas.core.shell.term.impl.httptelnet.NettyHttpTelnetTtyBootstrap;
import io.termd.core.function.Consumer;
import io.termd.core.tty.TtyConnection;
import java.util.concurrent.TimeUnit;

public class HttpTelnetTermServer
extends TermServer {
    private static final Logger logger = LoggerFactory.getLogger(HttpTelnetTermServer.class);
    private Handler<Term> termHandler;
    private NettyHttpTelnetTtyBootstrap bootstrap;
    private String hostIp;
    private int port;
    private long connectionTimeout;

    public HttpTelnetTermServer(String hostIp, int port, long connectionTimeout) {
        this.hostIp = hostIp;
        this.port = port;
        this.connectionTimeout = connectionTimeout;
    }

    @Override
    public TermServer termHandler(Handler<Term> handler) {
        this.termHandler = handler;
        return this;
    }

    @Override
    public TermServer listen(Handler<Future<TermServer>> listenHandler) {
        this.bootstrap = new NettyHttpTelnetTtyBootstrap().setHost(this.hostIp).setPort(this.port);
        try {
            this.bootstrap.start(new Consumer<TtyConnection>(){

                public void accept(TtyConnection conn) {
                    HttpTelnetTermServer.this.termHandler.handle(new TermImpl(Helper.loadKeymap(), conn));
                }
            }).get(this.connectionTimeout, TimeUnit.MILLISECONDS);
            listenHandler.handle(Future.succeededFuture());
        }
        catch (Throwable t) {
            logger.error("Error listening to port " + this.port, t);
            listenHandler.handle(Future.failedFuture(t));
        }
        return this;
    }

    @Override
    public int actualPort() {
        return this.bootstrap.getPort();
    }

    @Override
    public void close() {
        this.close(null);
    }

    @Override
    public void close(Handler<Future<Void>> completionHandler) {
        if (this.bootstrap != null) {
            this.bootstrap.stop();
            if (completionHandler != null) {
                completionHandler.handle(Future.succeededFuture());
            }
        } else if (completionHandler != null) {
            completionHandler.handle(Future.failedFuture("telnet term server not started"));
        }
    }
}

