/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.common.JavaVersionUtils;
import com.taobao.arthas.common.PidUtils;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import com.taobao.text.Decoration;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import sun.management.counter.Counter;
import sun.management.counter.perf.PerfInstrumentation;

@Name(value="perfcounter")
@Summary(value="Display the perf counter infornation.")
@Description(value="\nWIKI:\n  https://alibaba.github.io/arthas/perf")
public class PerfCounterCommand
extends AnnotatedCommand {
    private static final Logger logger = LoggerFactory.getLogger(PerfCounterCommand.class);
    private static Object perfObject;
    private static Method attachMethod;
    private boolean details;

    @Option(shortName="d", longName="details", flag=true)
    @Description(value="print all perf counter details")
    public void setDetails(boolean details) {
        this.details = details;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(CommandProcess process) {
        try {
            List<Counter> perfCounters;
            TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
            if (this.details) {
                table = new TableElement(new int[]{3, 1, 1, 10}).leftCellPadding(1).rightCellPadding(1);
                table.row(true, new Element[]{Element.label((String)"Name").style(Decoration.bold.bold()), Element.label((String)"Variability").style(Decoration.bold.bold()), Element.label((String)"Units").style(Decoration.bold.bold()), Element.label((String)"Value").style(Decoration.bold.bold())});
            }
            if ((perfCounters = PerfCounterCommand.getPerfCounters()).isEmpty()) {
                process.write("please check arthas log. if java version >=9 , try to add jvm options when start your process: --add-opens java.base/jdk.internal.perf=ALL-UNNAMED --add-exports java.base/jdk.internal.perf=ALL-UNNAMED\n");
            } else {
                for (Counter counter : perfCounters) {
                    if (this.details) {
                        table.row(new String[]{counter.getName(), String.valueOf(counter.getVariability()), String.valueOf(counter.getUnits()), String.valueOf(counter.getValue())});
                        continue;
                    }
                    table.row(new String[]{counter.getName(), String.valueOf(counter.getValue())});
                }
            }
            process.write(RenderUtil.render((Element)table, (int)process.width()));
        }
        finally {
            process.end();
        }
    }

    private static List<Counter> getPerfCounters() {
        try {
            if (perfObject == null) {
                String perfClassName = "sun.misc.Perf";
                if (!JavaVersionUtils.isLessThanJava9()) {
                    perfClassName = "jdk.internal.perf.Perf";
                }
                Class<?> perfClass = ClassLoader.getSystemClassLoader().loadClass(perfClassName);
                Method getPerfMethod = perfClass.getDeclaredMethod("getPerf", new Class[0]);
                perfObject = getPerfMethod.invoke(null, new Object[0]);
            }
            if (attachMethod == null) {
                attachMethod = perfObject.getClass().getDeclaredMethod("attach", Integer.TYPE, String.class);
            }
            ByteBuffer buffer = (ByteBuffer)attachMethod.invoke(perfObject, (int)PidUtils.currentLongPid(), "r");
            PerfInstrumentation perfInstrumentation = new PerfInstrumentation(buffer);
            return perfInstrumentation.getAllCounters();
        }
        catch (Throwable e) {
            logger.error("get perf counter error", e);
            return Collections.emptyList();
        }
    }
}

