/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.logger;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.common.IOUtils;
import com.taobao.arthas.common.ReflectUtils;
import com.taobao.arthas.core.command.logger.AsmRenameUtil;
import com.taobao.arthas.core.command.logger.Log4j2Helper;
import com.taobao.arthas.core.command.logger.Log4jHelper;
import com.taobao.arthas.core.command.logger.LogbackHelper;
import com.taobao.arthas.core.command.logger.LoggerHelper;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.ClassLoaderUtils;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import com.taobao.text.Decoration;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Name(value="logger")
@Summary(value="Print logger info, and update the logger level")
@Description(value="\nExamples:\n  logger\n  logger -c 327a647b\n  logger -c 327a647b --name ROOT --level debug\n  logger --include-no-appender\n\nWIKI:\n  https://alibaba.github.io/arthas/logger")
public class LoggerCommand
extends AnnotatedCommand {
    private static final Logger logger = LoggerFactory.getLogger(LoggerCommand.class);
    private static byte[] LoggerHelperBytes;
    private static byte[] Log4jHelperBytes;
    private static byte[] LogbackHelperBytes;
    private static byte[] Log4j2HelperBytes;
    private static Map<Class<?>, byte[]> classToBytesMap;
    private static String arthasClassLoaderHash;
    private String name;
    private String hashCode;
    private String level;
    private boolean includeNoAppender;

    @Option(shortName="n", longName="name")
    @Description(value="logger name")
    public void setName(String name) {
        this.name = name;
    }

    @Option(shortName="c", longName="classloader")
    @Description(value="classLoader hashcode, if no value is set, default value is SystemClassLoader")
    public void setHashCode(String hashCode) {
        this.hashCode = hashCode;
    }

    @Option(shortName="l", longName="level")
    @Description(value="set logger level")
    public void setLevel(String level) {
        this.level = level;
    }

    @Option(longName="include-no-appender", flag=true)
    @Description(value="include the loggers don't have appender, default value false")
    public void setHaveAppender(boolean includeNoAppender) {
        this.includeNoAppender = includeNoAppender;
    }

    @Override
    public void process(CommandProcess process) {
        int status = 0;
        try {
            if (this.name != null && this.level != null) {
                this.level(process);
            } else {
                this.loggers(process, this.name);
            }
        }
        finally {
            process.end(status);
        }
    }

    public void level(CommandProcess process) {
        Boolean updateResult;
        Instrumentation inst = process.session().getInstrumentation();
        boolean result = false;
        try {
            updateResult = this.updateLevel(inst, Log4jHelper.class);
            if (Boolean.TRUE.equals(updateResult)) {
                result = true;
            }
        }
        catch (Throwable e) {
            logger.error("logger command update log4j level error", e);
        }
        try {
            updateResult = this.updateLevel(inst, LogbackHelper.class);
            if (Boolean.TRUE.equals(updateResult)) {
                result = true;
            }
        }
        catch (Throwable e) {
            logger.error("logger command update logback level error", e);
        }
        try {
            updateResult = this.updateLevel(inst, Log4j2Helper.class);
            if (Boolean.TRUE.equals(updateResult)) {
                result = true;
            }
        }
        catch (Throwable e) {
            logger.error("logger command update log4j2 level error", e);
        }
        if (result) {
            process.write("Update logger level success.\n");
        } else {
            process.write("Update logger level fail. Try to specify the classloader with the -c option. Use `sc -d CLASSNAME` to find out the classloader hashcode.\n");
        }
    }

    public void loggers(CommandProcess process, String name) {
        LinkedHashMap<ClassLoader, LoggerTypes> classLoaderLoggerMap = new LinkedHashMap<ClassLoader, LoggerTypes>();
        for (Class clazz : process.session().getInstrumentation().getAllLoadedClasses()) {
            String className = clazz.getName();
            ClassLoader classLoader = clazz.getClassLoader();
            if (this.hashCode != null && !this.hashCode.equals(StringUtils.classLoaderHash(clazz)) || classLoader == null) continue;
            LoggerTypes loggerTypes = (LoggerTypes)classLoaderLoggerMap.get(classLoader);
            if (loggerTypes == null) {
                loggerTypes = new LoggerTypes();
                classLoaderLoggerMap.put(classLoader, loggerTypes);
            }
            if ("org.apache.log4j.Logger".equals(className)) {
                loggerTypes.addType(LoggerType.LOG4J);
                continue;
            }
            if ("ch.qos.logback.classic.Logger".equals(className)) {
                loggerTypes.addType(LoggerType.LOGBACK);
                continue;
            }
            if (!"org.apache.logging.log4j.Logger".equals(className)) continue;
            loggerTypes.addType(LoggerType.LOG4J2);
        }
        for (Map.Entry entry : classLoaderLoggerMap.entrySet()) {
            String renderResult;
            Map<String, Map<String, Object>> loggerInfoMap;
            ClassLoader classLoader = (ClassLoader)entry.getKey();
            LoggerTypes loggerTypes = (LoggerTypes)entry.getValue();
            if (loggerTypes.contains(LoggerType.LOG4J)) {
                loggerInfoMap = this.loggerInfo(classLoader, Log4jHelper.class);
                renderResult = this.renderLoggerInfo(loggerInfoMap, process.width());
                process.write(renderResult);
            }
            if (loggerTypes.contains(LoggerType.LOGBACK)) {
                loggerInfoMap = this.loggerInfo(classLoader, LogbackHelper.class);
                renderResult = this.renderLoggerInfo(loggerInfoMap, process.width());
                process.write(renderResult);
            }
            if (!loggerTypes.contains(LoggerType.LOG4J2)) continue;
            loggerInfoMap = this.loggerInfo(classLoader, Log4j2Helper.class);
            renderResult = this.renderLoggerInfo(loggerInfoMap, process.width());
            process.write(renderResult);
        }
    }

    private String renderLoggerInfo(Map<String, Map<String, Object>> loggerInfos, int width) {
        StringBuilder sb = new StringBuilder(8192);
        for (Map.Entry<String, Map<String, Object>> entry : loggerInfos.entrySet()) {
            Map<String, Object> info = entry.getValue();
            TableElement table = new TableElement(new int[]{2, 10}).leftCellPadding(1).rightCellPadding(1);
            TableElement appendersTable = new TableElement().rightCellPadding(1);
            Class clazz = (Class)info.get("class");
            table.row(new Element[]{Element.label((String)"name").style(Decoration.bold.bold()), Element.label((String)("" + info.get("name")))}).row(new Element[]{Element.label((String)"class").style(Decoration.bold.bold()), Element.label((String)("" + clazz.getName()))}).row(new Element[]{Element.label((String)"classLoader").style(Decoration.bold.bold()), Element.label((String)("" + clazz.getClassLoader()))}).row(new Element[]{Element.label((String)"classLoaderHash").style(Decoration.bold.bold()), Element.label((String)("" + StringUtils.classLoaderHash(clazz)))}).row(new Element[]{Element.label((String)"level").style(Decoration.bold.bold()), Element.label((String)("" + info.get("level")))});
            if (info.get("effectiveLevel") != null) {
                table.row(new Element[]{Element.label((String)"effectiveLevel").style(Decoration.bold.bold()), Element.label((String)("" + info.get("effectiveLevel")))});
            }
            if (info.get("config") != null) {
                table.row(new Element[]{Element.label((String)"config").style(Decoration.bold.bold()), Element.label((String)("" + info.get("config")))});
            }
            table.row(new Element[]{Element.label((String)"additivity").style(Decoration.bold.bold()), Element.label((String)("" + info.get("additivity")))}).row(new Element[]{Element.label((String)"codeSource").style(Decoration.bold.bold()), Element.label((String)("" + info.get("codeSource")))});
            List appenders = (List)info.get("appenders");
            if (appenders != null && !appenders.isEmpty()) {
                for (Map appenderInfo : appenders) {
                    Class appenderClass = (Class)appenderInfo.get("class");
                    appendersTable.row(new Element[]{Element.label((String)"name").style(Decoration.bold.bold()), Element.label((String)("" + appenderInfo.get("name")))});
                    appendersTable.row(new Element[]{Element.label((String)"class"), Element.label((String)("" + appenderClass.getName()))});
                    appendersTable.row(new Element[]{Element.label((String)"classLoader"), Element.label((String)("" + appenderClass.getClassLoader()))});
                    appendersTable.row(new Element[]{Element.label((String)"classLoaderHash"), Element.label((String)("" + StringUtils.classLoaderHash(appenderClass)))});
                    if (appenderInfo.get("file") != null) {
                        appendersTable.row(new Element[]{Element.label((String)"file"), Element.label((String)("" + appenderInfo.get("file")))});
                    }
                    if (appenderInfo.get("target") != null) {
                        appendersTable.row(new Element[]{Element.label((String)"target"), Element.label((String)("" + appenderInfo.get("target")))});
                    }
                    if (appenderInfo.get("blocking") != null) {
                        appendersTable.row(new Element[]{Element.label((String)"blocking"), Element.label((String)("" + appenderInfo.get("blocking")))});
                    }
                    if (appenderInfo.get("appenderRef") == null) continue;
                    appendersTable.row(new Element[]{Element.label((String)"appenderRef"), Element.label((String)("" + appenderInfo.get("appenderRef")))});
                }
                table.row(new Element[]{Element.label((String)"appenders").style(Decoration.bold.bold()), appendersTable});
            }
            sb.append(RenderUtil.render((Element)table, (int)width)).append('\n');
        }
        return sb.toString();
    }

    private static String helperClassNameWithClassLoader(ClassLoader classLoader, Class<?> helperClass) {
        String classLoaderHash = ClassLoaderUtils.classLoaderHash(classLoader);
        String className = helperClass.getName();
        return className + arthasClassLoaderHash + classLoaderHash;
    }

    private Map<String, Map<String, Object>> loggerInfo(ClassLoader classLoader, Class<?> helperClass) {
        Map loggers = Collections.emptyMap();
        String helperClassName = LoggerCommand.helperClassNameWithClassLoader(classLoader, helperClass);
        try {
            classLoader.loadClass(helperClassName);
        }
        catch (ClassNotFoundException e) {
            try {
                byte[] helperClassBytes = AsmRenameUtil.renameClass(classToBytesMap.get(helperClass), helperClass.getName(), helperClassName);
                ReflectUtils.defineClass((String)helperClassName, (byte[])helperClassBytes, (ClassLoader)classLoader);
            }
            catch (Throwable e1) {
                logger.error("arthas loggger command try to define helper class error: " + helperClassName, e1);
            }
        }
        try {
            Class<?> clazz = classLoader.loadClass(helperClassName);
            Method getLoggersMethod = clazz.getMethod("getLoggers", String.class, Boolean.TYPE);
            loggers = (Map)getLoggersMethod.invoke(null, this.name, this.includeNoAppender);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return loggers;
    }

    private Boolean updateLevel(Instrumentation inst, Class<?> helperClass) throws Exception {
        ClassLoader classLoader = null;
        classLoader = this.hashCode == null ? ClassLoader.getSystemClassLoader() : ClassLoaderUtils.getClassLoader(inst, this.hashCode);
        Class<?> clazz = classLoader.loadClass(LoggerCommand.helperClassNameWithClassLoader(classLoader, helperClass));
        Method updateLevelMethod = clazz.getMethod("updateLevel", String.class, String.class);
        return (Boolean)updateLevelMethod.invoke(null, this.name, this.level);
    }

    private static byte[] loadClassBytes(Class<?> clazz) {
        try {
            InputStream stream = LoggerCommand.class.getClassLoader().getResourceAsStream(clazz.getName().replace('.', '/') + ".class");
            return IOUtils.getBytes((InputStream)stream);
        }
        catch (IOException e) {
            return null;
        }
    }

    static {
        classToBytesMap = new HashMap();
        arthasClassLoaderHash = ClassLoaderUtils.classLoaderHash(LoggerCommand.class.getClassLoader());
        LoggerHelperBytes = LoggerCommand.loadClassBytes(LoggerHelper.class);
        Log4jHelperBytes = LoggerCommand.loadClassBytes(Log4jHelper.class);
        LogbackHelperBytes = LoggerCommand.loadClassBytes(LogbackHelper.class);
        Log4j2HelperBytes = LoggerCommand.loadClassBytes(Log4j2Helper.class);
        classToBytesMap.put(LoggerHelper.class, LoggerHelperBytes);
        classToBytesMap.put(Log4jHelper.class, Log4jHelperBytes);
        classToBytesMap.put(LogbackHelper.class, LogbackHelperBytes);
        classToBytesMap.put(Log4j2Helper.class, Log4j2HelperBytes);
    }

    static class LoggerTypes {
        Set<LoggerType> types = new HashSet<LoggerType>();

        LoggerTypes() {
        }

        public Collection<LoggerType> types() {
            return this.types;
        }

        public void addType(LoggerType type) {
            this.types.add(type);
        }

        public boolean contains(LoggerType type) {
            return this.types.contains((Object)type);
        }
    }

    static enum LoggerType {
        LOG4J,
        LOGBACK,
        LOG4J2;

    }
}

