/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.klass100;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.command.klass100.ClassDumpTransformer;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.ClassUtils;
import com.taobao.arthas.core.util.Decompiler;
import com.taobao.arthas.core.util.SearchUtils;
import com.taobao.arthas.core.util.TypeRenderUtils;
import com.taobao.arthas.core.util.affect.RowAffect;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import com.taobao.text.Color;
import com.taobao.text.Decoration;
import com.taobao.text.lang.LangRenderUtil;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.LabelElement;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.io.File;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

@Name(value="jad")
@Summary(value="Decompile class")
@Description(value="\nEXAMPLES:\n  jad java.lang.String\n  jad java.lang.String toString\n  jad --source-only java.lang.String\n  jad -c 39eb305e org/apache/log4j/Logger\n  jad -c 39eb305e -E org\\\\.apache\\\\.*\\\\.StringUtils\n\nWIKI:\n  https://alibaba.github.io/arthas/jad")
public class JadCommand
extends AnnotatedCommand {
    private static final Logger logger = LoggerFactory.getLogger(JadCommand.class);
    private static Pattern pattern = Pattern.compile("(?m)^/\\*\\s*\\*/\\s*$" + System.getProperty("line.separator"));
    private String classPattern;
    private String methodName;
    private String code = null;
    private boolean isRegEx = false;
    private boolean sourceOnly = false;

    @Argument(argName="class-pattern", index=0)
    @Description(value="Class name pattern, use either '.' or '/' as separator")
    public void setClassPattern(String classPattern) {
        this.classPattern = classPattern;
    }

    @Argument(argName="method-name", index=1, required=false)
    @Description(value="method name pattern, decompile a specific method instead of the whole class")
    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    @Option(shortName="c", longName="code")
    @Description(value="The hash code of the special class's classLoader")
    public void setCode(String code) {
        this.code = code;
    }

    @Option(shortName="E", longName="regex", flag=true)
    @Description(value="Enable regular expression to match (wildcard matching by default)")
    public void setRegEx(boolean regEx) {
        this.isRegEx = regEx;
    }

    @Option(longName="source-only", flag=true)
    @Description(value="Output source code only")
    public void setSourceOnly(boolean sourceOnly) {
        this.sourceOnly = sourceOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(CommandProcess process) {
        RowAffect affect = new RowAffect();
        Instrumentation inst = process.session().getInstrumentation();
        Set<Class<?>> matchedClasses = SearchUtils.searchClassOnly(inst, this.classPattern, this.isRegEx, this.code);
        try {
            if (matchedClasses == null || matchedClasses.isEmpty()) {
                this.processNoMatch(process);
            } else if (matchedClasses.size() > 1) {
                this.processMatches(process, matchedClasses);
            } else {
                Set<Class<?>> withInnerClasses = SearchUtils.searchClassOnly(inst, matchedClasses.iterator().next().getName() + "$*", false, this.code);
                if (withInnerClasses.isEmpty()) {
                    withInnerClasses = matchedClasses;
                }
                this.processExactMatch(process, affect, inst, matchedClasses, withInnerClasses);
            }
        }
        finally {
            if (!this.sourceOnly) {
                process.write(affect + "\n");
            }
            process.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void retransformClasses(Instrumentation inst, ClassFileTransformer transformer, Set<Class<?>> classes) {
        try {
            inst.addTransformer(transformer, true);
            for (Class<?> clazz : classes) {
                try {
                    inst.retransformClasses(clazz);
                }
                catch (Throwable e) {
                    String errorMsg = "retransformClasses class error, name: " + clazz.getName();
                    if (ClassUtils.isLambdaClass(clazz) && e instanceof VerifyError) {
                        errorMsg = errorMsg + ", Please ignore lambda class VerifyError: https://github.com/alibaba/arthas/issues/675";
                    }
                    logger.error(errorMsg, e);
                }
            }
        }
        finally {
            inst.removeTransformer(transformer);
        }
    }

    private void processExactMatch(CommandProcess process, RowAffect affect, Instrumentation inst, Set<Class<?>> matchedClasses, Set<Class<?>> withInnerClasses) {
        Class<?> c = matchedClasses.iterator().next();
        HashSet allClasses = new HashSet(withInnerClasses);
        allClasses.add(c);
        try {
            ClassDumpTransformer transformer = new ClassDumpTransformer(allClasses);
            JadCommand.retransformClasses(inst, transformer, allClasses);
            Map<Class<?>, File> classFiles = transformer.getDumpResult();
            File classFile = classFiles.get(c);
            String source = Decompiler.decompile(classFile.getAbsolutePath(), this.methodName);
            source = source != null ? pattern.matcher(source).replaceAll("") : "unknown";
            if (this.sourceOnly) {
                process.write(LangRenderUtil.render((String)source) + "\n");
                return;
            }
            process.write("\n");
            process.write(RenderUtil.render((Element)new LabelElement("ClassLoader: ").style(Decoration.bold.fg(Color.red)), (int)process.width()));
            process.write(RenderUtil.render((Element)TypeRenderUtils.drawClassLoader(c), (int)process.width()) + "\n");
            process.write(RenderUtil.render((Element)new LabelElement("Location: ").style(Decoration.bold.fg(Color.red)), (int)process.width()));
            process.write(RenderUtil.render((Element)new LabelElement(ClassUtils.getCodeSource(c.getProtectionDomain().getCodeSource())).style(Decoration.bold.fg(Color.blue)), (int)process.width()) + "\n");
            process.write(LangRenderUtil.render((String)source) + "\n");
            process.write("");
            affect.rCnt(classFiles.keySet().size());
        }
        catch (Throwable t) {
            logger.error("jad: fail to decompile class: " + c.getName(), t);
        }
    }

    private void processMatches(CommandProcess process, Set<Class<?>> matchedClasses) {
        LabelElement usage = new LabelElement("jad -c <hashcode> " + this.classPattern).style(Decoration.bold.fg(Color.blue));
        process.write("\n Found more than one class for: " + this.classPattern + ", Please use " + RenderUtil.render((Element)usage, (int)process.width()));
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        table.row(new Element[]{new LabelElement("HASHCODE").style(Decoration.bold.bold()), new LabelElement("CLASSLOADER").style(Decoration.bold.bold())});
        for (Class<?> c : matchedClasses) {
            ClassLoader classLoader = c.getClassLoader();
            table.row(new Element[]{Element.label((String)Integer.toHexString(classLoader.hashCode())).style(Decoration.bold.fg(Color.red)), TypeRenderUtils.drawClassLoader(c)});
        }
        process.write(RenderUtil.render((Element)table, (int)process.width()) + "\n");
    }

    private void processNoMatch(CommandProcess process) {
        process.write("No class found for: " + this.classPattern + "\n");
    }

    @Override
    public void complete(Completion completion) {
        int argumentIndex = CompletionUtils.detectArgumentIndex(completion);
        if (argumentIndex == 1) {
            if (!CompletionUtils.completeClassName(completion)) {
                super.complete(completion);
            }
            return;
        }
        if (argumentIndex == 2) {
            if (!CompletionUtils.completeMethodName(completion)) {
                super.complete(completion);
            }
            return;
        }
        super.complete(completion);
    }
}

