/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.term.impl.http;

import com.taobao.arthas.core.shell.term.impl.http.TtyServerInitializer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.termd.core.function.Consumer;
import io.termd.core.tty.TtyConnection;
import io.termd.core.util.CompletableFuture;
import io.termd.core.util.Helper;

public class NettyWebsocketTtyBootstrap {
    private final ChannelGroup channelGroup = new DefaultChannelGroup((EventExecutor)ImmediateEventExecutor.INSTANCE);
    private String host = "localhost";
    private int port = 8080;
    private EventLoopGroup group;
    private Channel channel;

    public String getHost() {
        return this.host;
    }

    public NettyWebsocketTtyBootstrap setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public NettyWebsocketTtyBootstrap setPort(int port) {
        this.port = port;
        return this;
    }

    public void start(Consumer<TtyConnection> handler, final Consumer<Throwable> doneHandler) {
        this.group = new NioEventLoopGroup();
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)b.group(this.group).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new TtyServerInitializer(this.channelGroup, handler));
        final ChannelFuture f = b.bind(this.host, this.port);
        f.addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

            public void operationComplete(Future<? super Void> future) throws Exception {
                if (future.isSuccess()) {
                    NettyWebsocketTtyBootstrap.this.channel = f.channel();
                    doneHandler.accept(null);
                } else {
                    doneHandler.accept((Object)future.cause());
                }
            }
        });
    }

    public CompletableFuture<Void> start(Consumer<TtyConnection> handler) {
        CompletableFuture fut = new CompletableFuture();
        this.start(handler, (Consumer<Throwable>)Helper.startedHandler((CompletableFuture)fut));
        return fut;
    }

    public void stop(final Consumer<Throwable> doneHandler) {
        if (this.channel != null) {
            this.channel.close();
        }
        this.channelGroup.close().addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

            public void operationComplete(Future<? super Void> future) throws Exception {
                try {
                    doneHandler.accept((Object)future.cause());
                }
                finally {
                    NettyWebsocketTtyBootstrap.this.group.shutdownGracefully();
                }
            }
        });
    }

    public CompletableFuture<Void> stop() {
        CompletableFuture fut = new CompletableFuture();
        this.stop((Consumer<Throwable>)Helper.stoppedHandler((CompletableFuture)fut));
        return fut;
    }
}

