/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.session.impl;

import com.taobao.arthas.core.shell.ShellServer;
import com.taobao.arthas.core.shell.command.CommandResolver;
import com.taobao.arthas.core.shell.session.Session;
import com.taobao.arthas.core.shell.system.impl.InternalCommandManager;
import java.lang.instrument.Instrumentation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class SessionImpl
implements Session {
    private static final AtomicInteger lockSequence = new AtomicInteger();
    private static final int LOCK_TX_EMPTY = -1;
    private final AtomicInteger lock = new AtomicInteger(-1);
    private Map<String, Object> data = new HashMap<String, Object>();

    @Override
    public Session put(String key, Object obj) {
        if (obj == null) {
            this.data.remove(key);
        } else {
            this.data.put(key, obj);
        }
        return this;
    }

    @Override
    public <T> T get(String key) {
        return (T)this.data.get(key);
    }

    @Override
    public <T> T remove(String key) {
        return (T)this.data.remove(key);
    }

    @Override
    public boolean tryLock() {
        return this.lock.compareAndSet(-1, lockSequence.getAndIncrement());
    }

    @Override
    public void unLock() {
        int currentLockTx = this.lock.get();
        if (!this.lock.compareAndSet(currentLockTx, -1)) {
            throw new IllegalStateException();
        }
    }

    @Override
    public boolean isLocked() {
        return this.lock.get() != -1;
    }

    @Override
    public int getLock() {
        return this.lock.get();
    }

    @Override
    public String getSessionId() {
        return (String)this.data.get("id");
    }

    @Override
    public ShellServer getServer() {
        return (ShellServer)this.data.get("server");
    }

    @Override
    public int getPid() {
        return (Integer)this.data.get("pid");
    }

    @Override
    public List<CommandResolver> getCommandResolvers() {
        InternalCommandManager commandManager = (InternalCommandManager)this.data.get("arthas-command-manager");
        return commandManager.getResolvers();
    }

    @Override
    public Instrumentation getInstrumentation() {
        return (Instrumentation)this.data.get("instrumentation");
    }
}

