/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.command;

import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.Command;
import com.taobao.arthas.core.shell.command.CommandResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class CommandRegistry
implements CommandResolver {
    final ConcurrentHashMap<String, Command> commandMap = new ConcurrentHashMap();

    public static CommandRegistry create() {
        return new CommandRegistry();
    }

    public CommandRegistry registerCommand(Class<? extends AnnotatedCommand> command) {
        return this.registerCommand(Command.create(command));
    }

    public CommandRegistry registerCommand(Command command) {
        return this.registerCommands(Collections.singletonList(command));
    }

    public CommandRegistry registerCommands(List<Command> commands) {
        for (Command command : commands) {
            this.commandMap.put(command.name(), command);
        }
        return this;
    }

    public CommandRegistry unregisterCommand(String commandName) {
        this.commandMap.remove(commandName);
        return this;
    }

    @Override
    public List<Command> commands() {
        return new ArrayList<Command>(this.commandMap.values());
    }
}

