/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.taobao.arthas.core.advisor.Advice;
import com.taobao.arthas.core.advisor.ArthasMethod;
import com.taobao.arthas.core.advisor.ReflectAdviceListenerAdapter;
import com.taobao.arthas.core.command.express.ExpressException;
import com.taobao.arthas.core.command.monitor200.TimeFragment;
import com.taobao.arthas.core.command.monitor200.TimeTunnelCommand;
import com.taobao.arthas.core.command.monitor200.TimeTunnelTable;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.arthas.core.util.ThreadLocalWatch;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.util.Date;

public class TimeTunnelAdviceListener
extends ReflectAdviceListenerAdapter {
    private TimeTunnelCommand command;
    private CommandProcess process;
    private volatile boolean isFirst = true;
    private final ThreadLocalWatch threadLocalWatch = new ThreadLocalWatch();

    public TimeTunnelAdviceListener(TimeTunnelCommand command, CommandProcess process) {
        this.command = command;
        this.process = process;
    }

    @Override
    public void before(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args) throws Throwable {
        this.threadLocalWatch.start();
    }

    @Override
    public void afterReturning(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args, Object returnObject) throws Throwable {
        this.afterFinishing(Advice.newForAfterRetuning(loader, clazz, method, target, args, returnObject));
    }

    @Override
    public void afterThrowing(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args, Throwable throwable) {
        this.afterFinishing(Advice.newForAfterThrowing(loader, clazz, method, target, args, throwable));
    }

    private void afterFinishing(Advice advice) {
        double cost = this.threadLocalWatch.costInMillis();
        TimeFragment timeTunnel = new TimeFragment(advice, new Date(), cost);
        boolean match = false;
        try {
            match = this.isConditionMet(this.command.getConditionExpress(), advice, cost);
        }
        catch (ExpressException e) {
            LogUtil.getArthasLogger().warn("tt failed.", (Throwable)e);
            this.process.write("tt failed, condition is: " + this.command.getConditionExpress() + ", " + e.getMessage() + ", visit " + LogUtil.LOGGER_FILE + " for more details.\n");
            this.process.end();
        }
        if (!match) {
            return;
        }
        int index = this.command.putTimeTunnel(timeTunnel);
        TableElement table = TimeTunnelTable.createTable();
        if (this.isFirst) {
            this.isFirst = false;
            TimeTunnelTable.fillTableHeader(table);
        }
        TimeTunnelTable.fillTableRow(table, index, timeTunnel);
        this.process.write(RenderUtil.render((Element)table, (int)this.process.width()));
        this.process.times().incrementAndGet();
        if (this.isLimitExceeded(this.command.getNumberOfLimit(), this.process.times().get())) {
            this.abortProcess(this.process, this.command.getNumberOfLimit());
        }
    }
}

