/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.basic1000;

import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.shell.session.Session;
import com.taobao.arthas.core.shell.term.impl.TermImpl;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import io.termd.core.readline.Readline;
import io.termd.core.util.Helper;
import java.util.ArrayList;
import java.util.List;

@Name(value="history")
@Summary(value="Display command history")
@Description(value="\nEXAMPLES:\n  history\n  history -c\n  history 5\n")
public class HistoryCommand
extends AnnotatedCommand {
    boolean clear = false;
    int n = -1;

    @Option(shortName="c", longName="clear")
    @Description(value="clear history")
    public void setClear(boolean clear) {
        this.clear = clear;
    }

    @Argument(index=0, argName="n", required=false)
    @Description(value="how many history commnads to display")
    public void setNumber(int n) {
        this.n = n;
    }

    @Override
    public void process(CommandProcess process) {
        Session session = process.session();
        Object termObject = session.get("tty");
        if (termObject != null && termObject instanceof TermImpl) {
            TermImpl term = (TermImpl)termObject;
            Readline readline = term.getReadline();
            List history = readline.getHistory();
            if (this.clear) {
                readline.setHistory(new ArrayList());
            } else {
                StringBuilder sb = new StringBuilder();
                int size = history.size();
                if (this.n < 0) {
                    this.n = size;
                }
                for (int i = 0; i < this.n; ++i) {
                    int[] line = (int[])history.get(this.n - i - 1);
                    sb.append(String.format("%5s  ", size - (this.n - i - 1)));
                    Helper.appendCodePoints((int[])line, (StringBuilder)sb);
                    sb.append('\n');
                }
                process.write(sb.toString());
            }
        }
        process.end();
    }
}

