/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.term.impl.httptelnet;

import com.taobao.arthas.core.shell.term.impl.httptelnet.HttpRequestHandler;
import com.taobao.arthas.core.shell.term.impl.httptelnet.TtyWebSocketFrameHandler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.concurrent.ScheduledFuture;
import io.termd.core.function.Consumer;
import io.termd.core.function.Supplier;
import io.termd.core.telnet.TelnetHandler;
import io.termd.core.telnet.netty.TelnetChannelHandler;
import io.termd.core.tty.TtyConnection;
import java.io.File;
import java.util.concurrent.TimeUnit;

public class ProtocolDetectHandler
extends ChannelInboundHandlerAdapter {
    private ChannelGroup channelGroup;
    private Supplier<TelnetHandler> handlerFactory;
    private Consumer<TtyConnection> ttyConnectionFactory;
    private ScheduledFuture<?> detectTelnetFuture;

    public ProtocolDetectHandler(ChannelGroup channelGroup, Supplier<TelnetHandler> handlerFactory, Consumer<TtyConnection> ttyConnectionFactory) {
        this.channelGroup = channelGroup;
        this.handlerFactory = handlerFactory;
        this.ttyConnectionFactory = ttyConnectionFactory;
    }

    public void channelActive(final ChannelHandlerContext ctx) throws Exception {
        this.detectTelnetFuture = ctx.channel().eventLoop().schedule(new Runnable(){

            @Override
            public void run() {
                ProtocolDetectHandler.this.channelGroup.add((Object)ctx.channel());
                TelnetChannelHandler handler = new TelnetChannelHandler(ProtocolDetectHandler.this.handlerFactory);
                ChannelPipeline pipeline = ctx.pipeline();
                pipeline.addLast(new ChannelHandler[]{handler});
                pipeline.remove((ChannelHandler)ProtocolDetectHandler.this);
                ctx.fireChannelActive();
            }
        }, 1000L, TimeUnit.MILLISECONDS);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf in = (ByteBuf)msg;
        if (in.readableBytes() < 3) {
            return;
        }
        if (this.detectTelnetFuture != null && this.detectTelnetFuture.isCancellable()) {
            this.detectTelnetFuture.cancel(false);
        }
        byte[] bytes = new byte[3];
        in.getBytes(0, bytes);
        String httpHeader = new String(bytes);
        ChannelPipeline pipeline = ctx.pipeline();
        if (!"GET".equalsIgnoreCase(httpHeader)) {
            this.channelGroup.add((Object)ctx.channel());
            TelnetChannelHandler handler = new TelnetChannelHandler(this.handlerFactory);
            pipeline.addLast(new ChannelHandler[]{handler});
            ctx.fireChannelActive();
        } else {
            pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
            pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
            pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
            pipeline.addLast(new ChannelHandler[]{new HttpRequestHandler("/ws", new File("arthas-output"))});
            pipeline.addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler("/ws")});
            pipeline.addLast(new ChannelHandler[]{new TtyWebSocketFrameHandler(this.channelGroup, this.ttyConnectionFactory)});
            ctx.fireChannelActive();
        }
        pipeline.remove((ChannelHandler)this);
        ctx.fireChannelRead((Object)in);
    }
}

