/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.term.impl.httptelnet;

import com.taobao.arthas.common.IOUtils;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class DirectoryBrowser {
    private static String pageHeader = "<!DOCTYPE html>\n<html>\n\n<head>\n    <title>Arthas Resouces: %s</title>\n    <meta charset=\"utf-8\" name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <style>\nbody {\n    background: #fff;\n}\n    </style>\n</head>\n\n<body>\n    <header>\n        <h1>%s</h1>\n    </header>\n    <hr/>\n    <main>\n        <pre id=\"contents\">\n";
    private static String pageFooter = "       </pre>\n    </main>\n    <hr/>\n</body>\n\n</html>";
    private static String linePart1Str = "<a href=\"%s\" title=\"%s\">";
    private static String linePart2Str = "%-60s";

    private static String renderDir(File dir) {
        Object[] listFiles = dir.listFiles();
        StringBuilder sb = new StringBuilder(8192);
        String dirName = dir.getName() + "/";
        sb.append(String.format(pageHeader, dirName, dirName));
        sb.append("<a href=\"../\" title=\"../\">../</a>\n");
        if (listFiles != null) {
            String modifyStr;
            SimpleDateFormat simpleDateFormat;
            String part2Format;
            String linePart2;
            String part1Format;
            String name;
            Arrays.sort(listFiles);
            for (Object f : listFiles) {
                if (!((File)f).isDirectory()) continue;
                name = ((File)f).getName() + "/";
                part1Format = String.format(linePart1Str, name, name, name);
                sb.append(part1Format);
                linePart2 = name + "</a>";
                part2Format = String.format(linePart2Str, linePart2);
                sb.append(part2Format);
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                modifyStr = simpleDateFormat.format(new Date(((File)f).lastModified()));
                sb.append(modifyStr);
                sb.append("         -      ").append("\r\n");
            }
            for (Object f : listFiles) {
                if (!((File)f).isFile()) continue;
                name = ((File)f).getName();
                part1Format = String.format(linePart1Str, name, name, name);
                sb.append(part1Format);
                linePart2 = name + "</a>";
                part2Format = String.format(linePart2Str, linePart2);
                sb.append(part2Format);
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                modifyStr = simpleDateFormat.format(new Date(((File)f).lastModified()));
                sb.append(modifyStr);
                String sizeStr = String.format("%10d      ", ((File)f).length());
                sb.append(sizeStr).append("\r\n");
            }
        }
        sb.append(pageFooter);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DefaultFullHttpResponse view(File dir, String path, HttpVersion version) throws IOException {
        File file;
        if (path.startsWith("/")) {
            path = path.substring(1, path.length());
        }
        if (DirectoryBrowser.isSubFile(dir, file = new File(path))) {
            DefaultFullHttpResponse fullResp = new DefaultFullHttpResponse(version, HttpResponseStatus.OK);
            if (file.isDirectory()) {
                if (!path.endsWith("/")) {
                    fullResp.setStatus(HttpResponseStatus.FOUND).headers().set((CharSequence)HttpHeaderNames.LOCATION, (Object)("/" + path + "/"));
                }
                String renderResult = DirectoryBrowser.renderDir(file);
                fullResp.content().writeBytes(renderResult.getBytes("utf-8"));
                fullResp.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"content-type: text/html; charset=utf-8");
            } else {
                FileInputStream fileInputStream = new FileInputStream(file);
                try {
                    byte[] content = IOUtils.getBytes((InputStream)fileInputStream);
                    fullResp.content().writeBytes(content);
                    HttpUtil.setContentLength((HttpMessage)fullResp, (long)fullResp.content().readableBytes());
                }
                finally {
                    IOUtils.close((InputStream)fileInputStream);
                }
            }
            return fullResp;
        }
        return null;
    }

    public static boolean isSubFile(File parent, File child) throws IOException {
        String childPath;
        String parentPath = parent.getCanonicalPath();
        return parentPath.equals(childPath = child.getCanonicalPath()) || childPath.startsWith(parent.getCanonicalPath() + File.separator);
    }
}

