/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.taobao.arthas.common.OSUtils;
import com.taobao.arthas.core.shell.cli.CliToken;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.DefaultValue;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import com.taobao.middleware.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.security.CodeSource;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import one.profiler.AsyncProfiler;
import one.profiler.Counter;

@Name(value="profiler")
@Summary(value="Async Profiler. https://github.com/jvm-profiling-tools/async-profiler")
@Description(value="\nEXAMPLES:\n  profiler start\n  profiler stop\n  profiler list                # list all supported events\n  profiler actions             # list all supported actions\n  profiler start --event alloc\n  profiler stop --format svg   # output file format, support svg,html,jfr\n  profiler stop --file /tmp/result.html\n  profiler stop --threads \n  profiler status\n  profiler resume              # Start or resume profiling without resetting collected data.\n  profiler getSamples          # Get the number of samples collected during the profiling session\n  profiler dumpFlat            # Dump flat profile, i.e. the histogram of the hottest methods\n  profiler dumpCollapsed       # Dump profile in 'collapsed stacktraces' format\n  profiler dumpTraces          # Dump collected stack traces\n  profiler execute 'start'                       # Execute an agent-compatible profiling command\n  profiler execute 'stop,file=/tmp/result.svg'   # Execute an agent-compatible profiling command\n\nWIKI:\n  https://alibaba.github.io/arthas/profiler")
public class ProfilerCommand
extends AnnotatedCommand {
    private static final Logger logger;
    private String action;
    private String actionArg;
    private String event;
    private String file;
    private String format;
    private Long interval;
    private boolean threads;
    private boolean allkernel;
    private boolean alluser;
    private static String libPath;
    private static AsyncProfiler profiler;

    @Argument(argName="action", index=0, required=true)
    @Description(value="Action to execute")
    public void setAction(String action) {
        this.action = action;
    }

    @Argument(argName="actionArg", index=1, required=false)
    @Description(value="Attribute name pattern.")
    public void setActionArg(String actionArg) {
        this.actionArg = actionArg;
    }

    @Option(shortName="i", longName="interval")
    @Description(value="sampling interval in ns (default: 10'000'000, i.e. 10 ms)")
    @DefaultValue(value="10000000")
    public void setInterval(long interval) {
        this.interval = interval;
    }

    @Option(shortName="f", longName="file")
    @Description(value="dump output to <filename>")
    public void setFile(String file) {
        this.file = file;
    }

    @Option(longName="format")
    @Description(value="dump output file format(svg, html, jfr), default valut is svg")
    @DefaultValue(value="svg")
    public void setFormat(String format) {
        this.format = format;
    }

    @Option(shortName="e", longName="event")
    @Description(value="which event to trace (cpu, alloc, lock, cache-misses etc.), default value is cpu")
    @DefaultValue(value="cpu")
    public void setEvent(String event) {
        this.event = event;
    }

    @Option(longName="threads", flag=true)
    @Description(value="profile different threads separately")
    public void setThreads(boolean threads) {
        this.threads = threads;
    }

    @Option(longName="allkernel", flag=true)
    @Description(value="include only kernel-mode events")
    public void setAllkernel(boolean allkernel) {
        this.allkernel = allkernel;
    }

    @Option(longName="alluser", flag=true)
    @Description(value="include only user-mode events")
    public void setAlluser(boolean alluser) {
        this.alluser = alluser;
    }

    private AsyncProfiler profilerInstance() {
        if (profiler != null) {
            return profiler;
        }
        if (ProfilerAction.load.toString().equals(this.action)) {
            profiler = AsyncProfiler.getInstance(this.actionArg);
        }
        if (libPath == null) {
            if (OSUtils.isLinux() || OSUtils.isMac()) {
                throw new IllegalStateException("Can not find libasyncProfiler so, please check the arthas directory.");
            }
            throw new IllegalStateException("Current OS do not support AsyncProfiler, Only support Linux/Mac.");
        }
        profiler = AsyncProfiler.getInstance(libPath);
        return profiler;
    }

    private String executeArgs(ProfilerAction action) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)action).append(',');
        if (this.event != null) {
            sb.append("event=").append(this.event).append(',');
        }
        if (this.file != null) {
            sb.append("file=").append(this.file).append(',');
        }
        if (this.interval != null) {
            sb.append("interval=").append(this.interval).append(',');
        }
        if (this.threads) {
            sb.append("threads").append(',');
        }
        if (this.allkernel) {
            sb.append("allkernel").append(',');
        }
        if (this.alluser) {
            sb.append("alluser").append(',');
        }
        return sb.toString();
    }

    private static String execute(AsyncProfiler asyncProfiler, String arg) throws IllegalArgumentException, IOException {
        String result = asyncProfiler.execute(arg);
        if (!result.endsWith("\n")) {
            result = result + "\n";
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(CommandProcess process) {
        int status = 0;
        try {
            ProfilerAction profilerAction = ProfilerAction.valueOf(this.action);
            if (ProfilerAction.actions.equals((Object)profilerAction)) {
                process.write("Supported Actions: " + this.actions() + "\n");
                return;
            }
            AsyncProfiler asyncProfiler = this.profilerInstance();
            if (ProfilerAction.execute.equals((Object)profilerAction)) {
                String result = ProfilerCommand.execute(asyncProfiler, this.actionArg);
                process.write(result);
            } else if (ProfilerAction.start.equals((Object)profilerAction)) {
                String executeArgs = this.executeArgs(ProfilerAction.start);
                String result = ProfilerCommand.execute(asyncProfiler, executeArgs);
                process.write(result);
            } else if (ProfilerAction.stop.equals((Object)profilerAction)) {
                if (this.file == null) {
                    this.file = new File("arthas-output", new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date()) + "." + this.format).getAbsolutePath();
                }
                process.write("profiler output file: " + new File(this.file).getAbsolutePath() + "\n");
                String executeArgs = this.executeArgs(ProfilerAction.stop);
                String result = ProfilerCommand.execute(asyncProfiler, executeArgs);
                process.write(result);
            } else if (ProfilerAction.resume.equals((Object)profilerAction)) {
                String executeArgs = this.executeArgs(ProfilerAction.resume);
                String result = ProfilerCommand.execute(asyncProfiler, executeArgs);
                process.write(result);
            } else if (ProfilerAction.list.equals((Object)profilerAction)) {
                String result = asyncProfiler.execute("list");
                process.write(result);
            } else if (ProfilerAction.version.equals((Object)profilerAction)) {
                String result = asyncProfiler.execute("version");
                process.write(result);
            } else if (ProfilerAction.status.equals((Object)profilerAction)) {
                String result = asyncProfiler.execute("status");
                process.write(result);
            } else if (ProfilerAction.dumpCollapsed.equals((Object)profilerAction)) {
                if (this.actionArg == null) {
                    this.actionArg = "TOTAL";
                }
                this.actionArg = this.actionArg.toUpperCase();
                if ("TOTAL".equals(this.actionArg) || "SAMPLES".equals(this.actionArg)) {
                    String result = asyncProfiler.dumpCollapsed(Counter.valueOf(this.actionArg));
                    process.write(result);
                } else {
                    process.write("ERROR: dumpCollapsed argumment should be TOTAL or SAMPLES. \n");
                    status = 1;
                }
            } else if (ProfilerAction.dumpFlat.equals((Object)profilerAction)) {
                int maxMethods = 0;
                if (this.actionArg != null) {
                    maxMethods = Integer.valueOf(this.actionArg);
                }
                String result = asyncProfiler.dumpFlat(maxMethods);
                process.write(result);
            } else if (ProfilerAction.dumpTraces.equals((Object)profilerAction)) {
                int maxTraces = 0;
                if (this.actionArg != null) {
                    maxTraces = Integer.valueOf(this.actionArg);
                }
                String result = asyncProfiler.dumpTraces(maxTraces);
                process.write(result);
            } else if (ProfilerAction.getSamples.equals((Object)profilerAction)) {
                String result = "" + asyncProfiler.getSamples() + "\n";
                process.write(result);
            }
        }
        catch (Throwable e) {
            process.write(e.getMessage()).write("\n");
            logger.error("arthas", "AsyncProfiler error", e);
            status = 1;
        }
        finally {
            process.end(status);
        }
    }

    private List<String> events() {
        String execute;
        ArrayList<String> result = new ArrayList<String>();
        try {
            execute = this.profilerInstance().execute("list");
        }
        catch (Throwable e) {
            return result;
        }
        String[] lines = execute.split("\\r?\\n");
        if (lines != null) {
            for (String line : lines) {
                if (!line.startsWith(" ")) continue;
                result.add(line.trim());
            }
        }
        return result;
    }

    private Set<String> actions() {
        HashSet<String> values = new HashSet<String>();
        for (ProfilerAction action : ProfilerAction.values()) {
            values.add(action.toString());
        }
        return values;
    }

    @Override
    public void complete(Completion completion) {
        List<CliToken> tokens = completion.lineTokens();
        String token = tokens.get(tokens.size() - 1).value();
        if (tokens.size() >= 2) {
            CliToken cliToken_1 = tokens.get(tokens.size() - 1);
            CliToken cliToken_2 = tokens.get(tokens.size() - 2);
            if (cliToken_1.isBlank()) {
                String token_2 = cliToken_2.value();
                if (token_2.equals("-e") || token_2.equals("--event")) {
                    CompletionUtils.complete(completion, this.events());
                    return;
                }
                if (token_2.equals("-f") || token_2.equals("--format")) {
                    CompletionUtils.complete(completion, Arrays.asList("svg", "html", "jfr"));
                    return;
                }
            }
        }
        if (token.startsWith("-")) {
            super.complete(completion);
            return;
        }
        CompletionUtils.complete(completion, this.actions());
    }

    static {
        CodeSource codeSource;
        logger = LogUtil.getArthasLogger();
        profiler = null;
        String profierSoPath = null;
        if (OSUtils.isMac()) {
            profierSoPath = "async-profiler/libasyncProfiler-mac-x64.so";
        }
        if (OSUtils.isLinux()) {
            profierSoPath = "async-profiler/libasyncProfiler-linux-x64.so";
        }
        if (profierSoPath != null && (codeSource = ProfilerCommand.class.getProtectionDomain().getCodeSource()) != null) {
            try {
                File bootJarPath = new File(codeSource.getLocation().toURI().getSchemeSpecificPart());
                File soFile = new File(bootJarPath.getParentFile(), profierSoPath);
                if (soFile.exists()) {
                    libPath = soFile.getAbsolutePath();
                }
            }
            catch (Throwable e) {
                logger.error("arthas", "can not find libasyncProfiler so", e);
            }
        }
    }

    static enum ProfilerAction {
        execute,
        start,
        stop,
        resume,
        list,
        version,
        status,
        load,
        dumpCollapsed,
        dumpFlat,
        dumpTraces,
        getSamples,
        actions;

    }
}

