/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.handlers.shell;

import com.taobao.arthas.core.shell.cli.CliToken;
import com.taobao.arthas.core.shell.cli.CliTokens;
import com.taobao.arthas.core.shell.handlers.Handler;
import com.taobao.arthas.core.shell.impl.ShellImpl;
import com.taobao.arthas.core.shell.system.ExecStatus;
import com.taobao.arthas.core.shell.system.Job;
import com.taobao.arthas.core.shell.term.Term;
import com.taobao.arthas.core.util.TokenUtils;
import java.util.List;

public class ShellLineHandler
implements Handler<String> {
    private ShellImpl shell;
    private Term term;

    public ShellLineHandler(ShellImpl shell) {
        this.shell = shell;
        this.term = shell.term();
    }

    @Override
    public void handle(String line) {
        if (line == null) {
            this.handleExit();
            return;
        }
        List<CliToken> tokens = CliTokens.tokenize(line);
        CliToken first = TokenUtils.findFirstTextToken(tokens);
        if (first == null) {
            this.shell.readline();
            return;
        }
        String name = first.value();
        if (name.equals("exit") || name.equals("logout") || name.equals("quit")) {
            this.handleExit();
            return;
        }
        if (name.equals("jobs")) {
            this.handleJobs();
            return;
        }
        if (name.equals("fg")) {
            this.handleForeground(tokens);
            return;
        }
        if (name.equals("bg")) {
            this.handleBackground(tokens);
            return;
        }
        if (name.equals("kill")) {
            this.handleKill(tokens);
            return;
        }
        Job job = this.createJob(tokens);
        if (job != null) {
            job.run();
        }
    }

    private int getJobId(String arg) {
        int result = -1;
        try {
            result = arg.startsWith("%") ? Integer.parseInt(arg.substring(1)) : Integer.parseInt(arg);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private Job createJob(List<CliToken> tokens) {
        Job job;
        try {
            job = this.shell.createJob(tokens);
        }
        catch (Exception e) {
            this.term.echo(e.getMessage() + "\n");
            this.shell.readline();
            return null;
        }
        return job;
    }

    private void handleKill(List<CliToken> tokens) {
        String arg = TokenUtils.findSecondTokenText(tokens);
        if (arg == null) {
            this.term.write("kill: usage: kill job_id\n");
            this.shell.readline();
            return;
        }
        Job job = this.shell.jobController().getJob(this.getJobId(arg));
        if (job == null) {
            this.term.write(arg + " : no such job\n");
            this.shell.readline();
        } else {
            job.terminate();
            this.term.write("kill job " + job.id() + " success\n");
            this.shell.readline();
        }
    }

    private void handleBackground(List<CliToken> tokens) {
        String arg = TokenUtils.findSecondTokenText(tokens);
        Job job = arg == null ? this.shell.getForegroundJob() : this.shell.jobController().getJob(this.getJobId(arg));
        if (job == null) {
            this.term.write(arg + " : no such job\n");
            this.shell.readline();
        } else if (job.status() == ExecStatus.STOPPED) {
            job.resume(false);
            this.term.echo(this.shell.statusLine(job, ExecStatus.RUNNING));
            this.shell.readline();
        } else {
            this.term.write("job " + job.id() + " is already running\n");
            this.shell.readline();
        }
    }

    private void handleForeground(List<CliToken> tokens) {
        String arg = TokenUtils.findSecondTokenText(tokens);
        Job job = arg == null ? this.shell.getForegroundJob() : this.shell.jobController().getJob(this.getJobId(arg));
        if (job == null) {
            this.term.write(arg + " : no such job\n");
            this.shell.readline();
        } else if (job.getSession() != this.shell.session()) {
            this.term.write("job " + job.id() + " doesn't belong to this session, so can not fg it\n");
            this.shell.readline();
        } else if (job.status() == ExecStatus.STOPPED) {
            job.resume(true);
        } else if (job.status() == ExecStatus.RUNNING) {
            job.toForeground();
        } else {
            this.term.write("job " + job.id() + " is already terminated, so can not fg it\n");
            this.shell.readline();
        }
    }

    private void handleJobs() {
        for (Job job : this.shell.jobController().jobs()) {
            String statusLine = this.shell.statusLine(job, job.status());
            this.term.write(statusLine);
        }
        this.shell.readline();
    }

    private void handleExit() {
        this.term.close();
    }
}

