/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.taobao.arthas.core.advisor.AdviceListener;
import com.taobao.arthas.core.command.monitor200.EnhancerCommand;
import com.taobao.arthas.core.command.monitor200.PathTraceAdviceListener;
import com.taobao.arthas.core.command.monitor200.TraceAdviceListener;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.SearchUtils;
import com.taobao.arthas.core.util.matcher.GroupMatcher;
import com.taobao.arthas.core.util.matcher.Matcher;
import com.taobao.arthas.core.util.matcher.RegexMatcher;
import com.taobao.arthas.core.util.matcher.TrueMatcher;
import com.taobao.arthas.core.util.matcher.WildcardMatcher;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import java.util.ArrayList;
import java.util.List;

@Name(value="trace")
@Summary(value="Trace the execution time of specified method invocation.")
@Description(value="  The express may be one of the following expression (evaluated dynamically):\n          target : the object\n           clazz : the object's class\n          method : the constructor or method\n          params : the parameters array of method\n    params[0..n] : the element of parameters array\n       returnObj : the returned object of method\n        throwExp : the throw exception of method\n        isReturn : the method ended by return\n         isThrow : the method ended by throwing exception\n           #cost : the execution time in ms of method invocation\nEXAMPLES:\n  trace org.apache.commons.lang.StringUtils isBlank\n  trace *StringUtils isBlank\n  trace *StringUtils isBlank params[0].length==1\n  trace *StringUtils isBlank '#cost>100'\n  trace -E org\\\\.apache\\\\.commons\\\\.lang\\\\.StringUtils isBlank\n  trace -E com.test.ClassA|org.test.ClassB method1|method2|method3\n\nWIKI:\n  https://alibaba.github.io/arthas/trace")
public class TraceCommand
extends EnhancerCommand {
    private String classPattern;
    private String methodPattern;
    private String conditionExpress;
    private boolean isRegEx = false;
    private int numberOfLimit = 100;
    private List<String> pathPatterns;
    private boolean skipJDKTrace;

    @Argument(argName="class-pattern", index=0)
    @Description(value="Class name pattern, use either '.' or '/' as separator")
    public void setClassPattern(String classPattern) {
        this.classPattern = classPattern;
    }

    @Argument(argName="method-pattern", index=1)
    @Description(value="Method name pattern")
    public void setMethodPattern(String methodPattern) {
        this.methodPattern = methodPattern;
    }

    @Argument(argName="condition-express", index=2, required=false)
    @Description(value="Conditional expression in ognl style, for example:\n  TRUE  : 1==1\n  TRUE  : true\n  FALSE : false\n  TRUE  : 'params.length>=0'\n  FALSE : 1==2\n")
    public void setConditionExpress(String conditionExpress) {
        this.conditionExpress = conditionExpress;
    }

    @Option(shortName="E", longName="regex", flag=true)
    @Description(value="Enable regular expression to match (wildcard matching by default)")
    public void setRegEx(boolean regEx) {
        this.isRegEx = regEx;
    }

    @Option(shortName="n", longName="limits")
    @Description(value="Threshold of execution times")
    public void setNumberOfLimit(int numberOfLimit) {
        this.numberOfLimit = numberOfLimit;
    }

    @Option(shortName="p", longName="path", acceptMultipleValues=true)
    @Description(value="path tracing pattern")
    public void setPathPatterns(List<String> pathPatterns) {
        this.pathPatterns = pathPatterns;
    }

    @Option(shortName="j", longName="jdkMethodSkip")
    @Description(value="skip jdk method trace")
    public void setSkipJDKTrace(boolean skipJDKTrace) {
        this.skipJDKTrace = skipJDKTrace;
    }

    public String getClassPattern() {
        return this.classPattern;
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    public String getConditionExpress() {
        return this.conditionExpress;
    }

    public boolean isSkipJDKTrace() {
        return this.skipJDKTrace;
    }

    public boolean isRegEx() {
        return this.isRegEx;
    }

    public int getNumberOfLimit() {
        return this.numberOfLimit;
    }

    public List<String> getPathPatterns() {
        return this.pathPatterns;
    }

    @Override
    protected Matcher getClassNameMatcher() {
        if (this.classNameMatcher == null) {
            this.classNameMatcher = this.pathPatterns == null || this.pathPatterns.isEmpty() ? SearchUtils.classNameMatcher(this.getClassPattern(), this.isRegEx()) : this.getPathTracingClassMatcher();
        }
        return this.classNameMatcher;
    }

    @Override
    protected Matcher getMethodNameMatcher() {
        if (this.methodNameMatcher == null) {
            this.methodNameMatcher = this.pathPatterns == null || this.pathPatterns.isEmpty() ? SearchUtils.classNameMatcher(this.getMethodPattern(), this.isRegEx()) : this.getPathTracingMethodMatcher();
        }
        return this.methodNameMatcher;
    }

    @Override
    protected AdviceListener getAdviceListener(CommandProcess process) {
        if (this.pathPatterns == null || this.pathPatterns.isEmpty()) {
            return new TraceAdviceListener(this, process);
        }
        return new PathTraceAdviceListener(this, process);
    }

    private Matcher<String> getPathTracingClassMatcher() {
        ArrayList matcherList = new ArrayList();
        matcherList.add(SearchUtils.classNameMatcher(this.getClassPattern(), this.isRegEx()));
        if (null != this.getPathPatterns()) {
            for (String pathPattern : this.getPathPatterns()) {
                if (this.isRegEx()) {
                    matcherList.add(new RegexMatcher(pathPattern));
                    continue;
                }
                matcherList.add(new WildcardMatcher(pathPattern));
            }
        }
        return new GroupMatcher.Or<String>(matcherList);
    }

    private Matcher<String> getPathTracingMethodMatcher() {
        return new TrueMatcher<String>();
    }
}

