/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.logger;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.AsyncAppender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class Log4jHelper {
    private static boolean Log4j = false;

    public static Boolean updateLevel(String name, String level) {
        if (Log4j) {
            Level l = Level.toLevel((String)level, (Level)Level.ERROR);
            Logger logger = LogManager.getLoggerRepository().exists(name);
            if (logger != null) {
                logger.setLevel(l);
                return true;
            }
            Logger root = LogManager.getLoggerRepository().getRootLogger();
            if (root.getName().equals(name)) {
                root.setLevel(l);
                return true;
            }
            return false;
        }
        return null;
    }

    public static Map<String, Map<String, Object>> getLoggers(String name, boolean includeNoAppender) {
        HashMap<String, Map<String, Object>> loggerInfoMap = new HashMap<String, Map<String, Object>>();
        if (!Log4j) {
            return loggerInfoMap;
        }
        if (name != null && !name.trim().isEmpty()) {
            Logger logger = LogManager.getLoggerRepository().exists(name);
            if (logger != null) {
                loggerInfoMap.put(name, Log4jHelper.doGetLoggerInfo(logger));
            }
        } else {
            Logger root;
            List appenders;
            Map<String, Object> info;
            Enumeration loggers = LogManager.getLoggerRepository().getCurrentLoggers();
            if (loggers != null) {
                while (loggers.hasMoreElements()) {
                    Logger logger = (Logger)loggers.nextElement();
                    info = Log4jHelper.doGetLoggerInfo(logger);
                    if (!includeNoAppender) {
                        appenders = (List)info.get("appenders");
                        if (appenders == null || appenders.isEmpty()) continue;
                        loggerInfoMap.put(logger.getName(), info);
                        continue;
                    }
                    loggerInfoMap.put(logger.getName(), info);
                }
            }
            if ((root = LogManager.getLoggerRepository().getRootLogger()) != null) {
                info = Log4jHelper.doGetLoggerInfo(root);
                if (!includeNoAppender) {
                    appenders = (List)info.get("appenders");
                    if (appenders != null && !appenders.isEmpty()) {
                        loggerInfoMap.put(root.getName(), info);
                    }
                } else {
                    loggerInfoMap.put(root.getName(), info);
                }
            }
        }
        return loggerInfoMap;
    }

    private static Map<String, Object> doGetLoggerInfo(Logger logger) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("name", logger.getName());
        info.put("class", logger.getClass());
        info.put("additivity", logger.getAdditivity());
        Level level = logger.getLevel();
        Level effectiveLevel = logger.getEffectiveLevel();
        if (level != null) {
            info.put("level", level.toString());
        }
        if (effectiveLevel != null) {
            info.put("effectiveLevel", effectiveLevel.toString());
        }
        List<Map<String, Object>> result = Log4jHelper.doGetLoggerAppenders(logger.getAllAppenders());
        info.put("appenders", result);
        return info;
    }

    private static List<Map<String, Object>> doGetLoggerAppenders(Enumeration<Appender> appenders) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        while (appenders.hasMoreElements()) {
            HashMap<String, Object> info = new HashMap<String, Object>();
            Appender appender = appenders.nextElement();
            info.put("name", appender.getName());
            info.put("class", appender.getClass());
            result.add(info);
            if (appender instanceof FileAppender) {
                info.put("file", ((FileAppender)appender).getFile());
                continue;
            }
            if (appender instanceof ConsoleAppender) {
                info.put("target", ((ConsoleAppender)appender).getTarget());
                continue;
            }
            if (!(appender instanceof AsyncAppender)) continue;
            List<Map<String, Object>> asyncs = Log4jHelper.doGetLoggerAppenders(((AsyncAppender)appender).getAllAppenders());
            ArrayList<String> appenderRef = new ArrayList<String>();
            for (Map<String, Object> a : asyncs) {
                appenderRef.add((String)a.get("name"));
                result.add(a);
            }
            info.put("appenderRef", appenderRef);
        }
        return result;
    }

    static {
        try {
            Class<?> loggerClass = Class.forName("org.apache.log4j.Logger");
            if (loggerClass.getClassLoader().equals(Log4jHelper.class.getClassLoader())) {
                LogManager.getLoggerRepository();
                Log4j = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

