/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.sun.management.HotSpotDiagnosticMXBean;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import com.taobao.middleware.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Date;

@Name(value="heapdump")
@Summary(value="Heap dump")
@Description(value="\nExamples:\n  heapdump\n  heapdump --live\n  heapdump --live /tmp/dump.hprof\n\nWIKI:\n  https://alibaba.github.io/arthas/heapdump")
public class HeapDumpCommand
extends AnnotatedCommand {
    private static final Logger logger = LogUtil.getArthasLogger();
    private String file;
    private boolean live;

    @Argument(argName="file", index=0, required=false)
    @Description(value="Output file")
    public void setFile(String file) {
        this.file = file;
    }

    @Option(shortName="l", longName="live", flag=true)
    @Description(value="Dump only live objects; if not specified, all objects in the heap are dumped.")
    public void setLive(boolean live) {
        this.live = live;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(CommandProcess process) {
        int status = 0;
        try {
            String dumpFile = this.file;
            if (dumpFile == null || dumpFile.isEmpty()) {
                String date = new SimpleDateFormat("yyyy-MM-dd-HH-mm").format(new Date());
                File file = File.createTempFile("heapdump" + date + (this.live ? "-live" : ""), ".hprof");
                dumpFile = file.getAbsolutePath();
                file.delete();
            }
            process.write("Dumping heap to " + dumpFile + "...\n");
            HeapDumpCommand.run(process, dumpFile, this.live);
            process.write("Heap dump file created\n");
        }
        catch (Throwable t) {
            logger.error("arthas", "heap dump error", t);
            process.write("Heap dump error: " + t.getMessage() + '\n');
            status = 1;
        }
        finally {
            process.end(status);
        }
    }

    private static void run(CommandProcess process, String file, boolean live) throws IOException {
        HotSpotDiagnosticMXBean hotSpotDiagnosticMXBean = ManagementFactory.getPlatformMXBean(HotSpotDiagnosticMXBean.class);
        hotSpotDiagnosticMXBean.dumpHeap(file, live);
    }
}

