/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util;

import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.util.TypeRenderUtils;
import com.taobao.text.Decoration;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.TableElement;
import java.security.CodeSource;

public class ClassUtils {
    public static String getCodeSource(CodeSource cs) {
        if (null == cs || null == cs.getLocation() || null == cs.getLocation().getFile()) {
            return "";
        }
        return cs.getLocation().getFile();
    }

    public static boolean isLambdaClass(Class<?> clazz) {
        return clazz.getName().contains("$$Lambda$");
    }

    public static Element renderClassInfo(Class<?> clazz) {
        return ClassUtils.renderClassInfo(clazz, false, null);
    }

    public static Element renderClassInfo(Class<?> clazz, boolean isPrintField, Integer expand) {
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        CodeSource cs = clazz.getProtectionDomain().getCodeSource();
        table.row(new Element[]{Element.label((String)"class-info").style(Decoration.bold.bold()), Element.label((String)StringUtils.classname(clazz))}).row(new Element[]{Element.label((String)"code-source").style(Decoration.bold.bold()), Element.label((String)ClassUtils.getCodeSource(cs))}).row(new Element[]{Element.label((String)"name").style(Decoration.bold.bold()), Element.label((String)StringUtils.classname(clazz))}).row(new Element[]{Element.label((String)"isInterface").style(Decoration.bold.bold()), Element.label((String)("" + clazz.isInterface()))}).row(new Element[]{Element.label((String)"isAnnotation").style(Decoration.bold.bold()), Element.label((String)("" + clazz.isAnnotation()))}).row(new Element[]{Element.label((String)"isEnum").style(Decoration.bold.bold()), Element.label((String)("" + clazz.isEnum()))}).row(new Element[]{Element.label((String)"isAnonymousClass").style(Decoration.bold.bold()), Element.label((String)("" + clazz.isAnonymousClass()))}).row(new Element[]{Element.label((String)"isArray").style(Decoration.bold.bold()), Element.label((String)("" + clazz.isArray()))}).row(new Element[]{Element.label((String)"isLocalClass").style(Decoration.bold.bold()), Element.label((String)("" + clazz.isLocalClass()))}).row(new Element[]{Element.label((String)"isMemberClass").style(Decoration.bold.bold()), Element.label((String)("" + clazz.isMemberClass()))}).row(new Element[]{Element.label((String)"isPrimitive").style(Decoration.bold.bold()), Element.label((String)("" + clazz.isPrimitive()))}).row(new Element[]{Element.label((String)"isSynthetic").style(Decoration.bold.bold()), Element.label((String)("" + clazz.isSynthetic()))}).row(new Element[]{Element.label((String)"simple-name").style(Decoration.bold.bold()), Element.label((String)clazz.getSimpleName())}).row(new Element[]{Element.label((String)"modifier").style(Decoration.bold.bold()), Element.label((String)StringUtils.modifier(clazz.getModifiers(), ','))}).row(new Element[]{Element.label((String)"annotation").style(Decoration.bold.bold()), Element.label((String)TypeRenderUtils.drawAnnotation(clazz))}).row(new Element[]{Element.label((String)"interfaces").style(Decoration.bold.bold()), Element.label((String)TypeRenderUtils.drawInterface(clazz))}).row(new Element[]{Element.label((String)"super-class").style(Decoration.bold.bold()), TypeRenderUtils.drawSuperClass(clazz)}).row(new Element[]{Element.label((String)"class-loader").style(Decoration.bold.bold()), TypeRenderUtils.drawClassLoader(clazz)}).row(new Element[]{Element.label((String)"classLoaderHash").style(Decoration.bold.bold()), Element.label((String)StringUtils.classLoaderHash(clazz))});
        if (isPrintField) {
            table.row(new Element[]{Element.label((String)"fields"), TypeRenderUtils.drawField(clazz, expand)});
        }
        return table;
    }
}

