/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.util.affect.RowAffect;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Summary;
import com.taobao.text.Decoration;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;

@Name(value="jvm")
@Summary(value="Display the target JVM information")
@Description(value="\nWIKI:\n  https://alibaba.github.io/arthas/jvm")
public class JvmCommand
extends AnnotatedCommand {
    private final RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    private final ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
    private final CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
    private final Collection<GarbageCollectorMXBean> garbageCollectorMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
    private final Collection<MemoryManagerMXBean> memoryManagerMXBeans = ManagementFactory.getMemoryManagerMXBeans();
    private final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    private final OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
    private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();

    @Override
    public void process(CommandProcess process) {
        RowAffect affect = new RowAffect();
        TableElement table = new TableElement(new int[]{2, 5}).leftCellPadding(1).rightCellPadding(1);
        table.row(true, new Element[]{Element.label((String)"RUNTIME").style(Decoration.bold.bold())});
        this.drawRuntimeTable(table);
        table.row(new String[]{"", ""});
        table.row(true, new Element[]{Element.label((String)"CLASS-LOADING").style(Decoration.bold.bold())});
        this.drawClassLoadingTable(table);
        table.row(new String[]{"", ""});
        table.row(true, new Element[]{Element.label((String)"COMPILATION").style(Decoration.bold.bold())});
        this.drawCompilationTable(table);
        if (!this.garbageCollectorMXBeans.isEmpty()) {
            table.row(new String[]{"", ""});
            table.row(true, new Element[]{Element.label((String)"GARBAGE-COLLECTORS").style(Decoration.bold.bold())});
            this.drawGarbageCollectorsTable(table);
        }
        if (!this.memoryManagerMXBeans.isEmpty()) {
            table.row(new String[]{"", ""});
            table.row(true, new Element[]{Element.label((String)"MEMORY-MANAGERS").style(Decoration.bold.bold())});
            this.drawMemoryManagersTable(table);
        }
        table.row(new String[]{"", ""});
        table.row(true, new Element[]{Element.label((String)"MEMORY").style(Decoration.bold.bold())});
        this.drawMemoryTable(table);
        table.row(new String[]{"", ""});
        table.row(true, new Element[]{Element.label((String)"OPERATING-SYSTEM").style(Decoration.bold.bold())});
        this.drawOperatingSystemMXBeanTable(table);
        table.row(new String[]{"", ""});
        table.row(true, new Element[]{Element.label((String)"THREAD").style(Decoration.bold.bold())});
        this.drawThreadTable(table);
        table.row(new String[]{"", ""});
        table.row(true, new Element[]{Element.label((String)"FILE-DESCRIPTOR").style(Decoration.bold.bold())});
        this.drawFileDescriptorTable(table);
        process.write(RenderUtil.render((Element)table, (int)process.width()));
        process.write(affect.toString()).write("\n");
        process.end();
    }

    private void drawFileDescriptorTable(TableElement table) {
        table.row(new String[]{"MAX-FILE-DESCRIPTOR-COUNT", "" + this.invokeFileDescriptor(this.operatingSystemMXBean, "getMaxFileDescriptorCount")}).row(new String[]{"OPEN-FILE-DESCRIPTOR-COUNT", "" + this.invokeFileDescriptor(this.operatingSystemMXBean, "getOpenFileDescriptorCount")});
    }

    private long invokeFileDescriptor(OperatingSystemMXBean os, String name) {
        try {
            Method method = os.getClass().getDeclaredMethod(name, new Class[0]);
            method.setAccessible(true);
            return (Long)method.invoke((Object)os, new Object[0]);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private String toCol(Collection<String> strings) {
        StringBuilder colSB = new StringBuilder();
        if (strings.isEmpty()) {
            colSB.append("[]");
        } else {
            for (String str : strings) {
                colSB.append(str).append("\n");
            }
        }
        return colSB.toString();
    }

    private String toCol(String ... stringArray) {
        StringBuilder colSB = new StringBuilder();
        if (null == stringArray || stringArray.length == 0) {
            colSB.append("[]");
        } else {
            for (String str : stringArray) {
                colSB.append(str).append("\n");
            }
        }
        return colSB.toString();
    }

    private Element drawRuntimeTable(TableElement table) {
        String bootClassPath = "";
        try {
            bootClassPath = this.runtimeMXBean.getBootClassPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        table.row(new String[]{"MACHINE-NAME", this.runtimeMXBean.getName()}).row(new String[]{"JVM-START-TIME", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(this.runtimeMXBean.getStartTime()))}).row(new String[]{"MANAGEMENT-SPEC-VERSION", this.runtimeMXBean.getManagementSpecVersion()}).row(new String[]{"SPEC-NAME", this.runtimeMXBean.getSpecName()}).row(new String[]{"SPEC-VENDOR", this.runtimeMXBean.getSpecVendor()}).row(new String[]{"SPEC-VERSION", this.runtimeMXBean.getSpecVersion()}).row(new String[]{"VM-NAME", this.runtimeMXBean.getVmName()}).row(new String[]{"VM-VENDOR", this.runtimeMXBean.getVmVendor()}).row(new String[]{"VM-VERSION", this.runtimeMXBean.getVmVersion()}).row(new String[]{"INPUT-ARGUMENTS", this.toCol(this.runtimeMXBean.getInputArguments())}).row(new String[]{"CLASS-PATH", this.runtimeMXBean.getClassPath()}).row(new String[]{"BOOT-CLASS-PATH", bootClassPath}).row(new String[]{"LIBRARY-PATH", this.runtimeMXBean.getLibraryPath()});
        return table;
    }

    private Element drawClassLoadingTable(TableElement table) {
        table.row(new String[]{"LOADED-CLASS-COUNT", "" + this.classLoadingMXBean.getLoadedClassCount()}).row(new String[]{"TOTAL-LOADED-CLASS-COUNT", "" + this.classLoadingMXBean.getTotalLoadedClassCount()}).row(new String[]{"UNLOADED-CLASS-COUNT", "" + this.classLoadingMXBean.getUnloadedClassCount()}).row(new String[]{"IS-VERBOSE", "" + this.classLoadingMXBean.isVerbose()});
        return table;
    }

    private Element drawCompilationTable(TableElement table) {
        table.row(new String[]{"NAME", this.compilationMXBean.getName()});
        if (this.compilationMXBean.isCompilationTimeMonitoringSupported()) {
            table.row(new String[]{"TOTAL-COMPILE-TIME", this.compilationMXBean.getTotalCompilationTime() + "(ms)"});
        }
        return table;
    }

    private Element drawGarbageCollectorsTable(TableElement table) {
        for (GarbageCollectorMXBean garbageCollectorMXBean : this.garbageCollectorMXBeans) {
            table.row(new String[]{garbageCollectorMXBean.getName() + "\n[count/time]", garbageCollectorMXBean.getCollectionCount() + "/" + garbageCollectorMXBean.getCollectionTime() + "(ms)"});
        }
        return table;
    }

    private Element drawMemoryManagersTable(TableElement table) {
        for (MemoryManagerMXBean memoryManagerMXBean : this.memoryManagerMXBeans) {
            if (!memoryManagerMXBean.isValid()) continue;
            String name = memoryManagerMXBean.isValid() ? memoryManagerMXBean.getName() : memoryManagerMXBean.getName() + "(Invalid)";
            table.row(new String[]{name, this.toCol(memoryManagerMXBean.getMemoryPoolNames())});
        }
        return table;
    }

    private Element drawMemoryTable(TableElement table) {
        MemoryUsage heapMemoryUsage = this.memoryMXBean.getHeapMemoryUsage();
        table.row(new String[]{"HEAP-MEMORY-USAGE\n[committed/init/max/used]", this.formatMemoryByte(heapMemoryUsage.getCommitted()) + "/" + this.formatMemoryByte(heapMemoryUsage.getInit()) + "/" + this.formatMemoryByte(heapMemoryUsage.getMax()) + "/" + this.formatMemoryByte(heapMemoryUsage.getUsed())});
        MemoryUsage nonHeapMemoryUsage = this.memoryMXBean.getNonHeapMemoryUsage();
        table.row(new String[]{"NO-HEAP-MEMORY-USAGE\n[committed/init/max/used]", this.formatMemoryByte(nonHeapMemoryUsage.getCommitted()) + "/" + this.formatMemoryByte(nonHeapMemoryUsage.getInit()) + "/" + this.formatMemoryByte(nonHeapMemoryUsage.getMax()) + "/" + this.formatMemoryByte(nonHeapMemoryUsage.getUsed())});
        table.row(new String[]{"PENDING-FINALIZE-COUNT", "" + this.memoryMXBean.getObjectPendingFinalizationCount()});
        return table;
    }

    private String formatMemoryByte(long bytes) {
        return String.format("%s(%s)", bytes, StringUtils.humanReadableByteCount(bytes));
    }

    private Element drawOperatingSystemMXBeanTable(TableElement table) {
        table.row(new String[]{"OS", this.operatingSystemMXBean.getName()}).row(new String[]{"ARCH", this.operatingSystemMXBean.getArch()}).row(new String[]{"PROCESSORS-COUNT", "" + this.operatingSystemMXBean.getAvailableProcessors()}).row(new String[]{"LOAD-AVERAGE", "" + this.operatingSystemMXBean.getSystemLoadAverage()}).row(new String[]{"VERSION", this.operatingSystemMXBean.getVersion()});
        return table;
    }

    private Element drawThreadTable(TableElement table) {
        table.row(new String[]{"COUNT", "" + this.threadMXBean.getThreadCount()}).row(new String[]{"DAEMON-COUNT", "" + this.threadMXBean.getDaemonThreadCount()}).row(new String[]{"PEAK-COUNT", "" + this.threadMXBean.getPeakThreadCount()}).row(new String[]{"STARTED-COUNT", "" + this.threadMXBean.getTotalStartedThreadCount()}).row(new String[]{"DEADLOCK-COUNT", "" + this.getDeadlockedThreadsCount(this.threadMXBean)});
        return table;
    }

    private int getDeadlockedThreadsCount(ThreadMXBean threads) {
        long[] ids = threads.findDeadlockedThreads();
        if (ids == null) {
            return 0;
        }
        return ids.length;
    }
}

