/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.term.impl;

import com.taobao.arthas.core.shell.cli.CliToken;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.session.Session;
import com.taobao.arthas.core.util.StringUtils;
import io.termd.core.readline.Completion;
import io.termd.core.util.Helper;
import java.util.LinkedList;
import java.util.List;

class CompletionAdaptor
implements com.taobao.arthas.core.shell.cli.Completion {
    private final Session session;
    private final String line;
    private final List<CliToken> tokens;
    private final Completion completion;

    public CompletionAdaptor(String line, List<CliToken> tokens, Completion completion, Session session) {
        this.line = line;
        this.tokens = tokens;
        this.completion = completion;
        this.session = session;
    }

    @Override
    public Session session() {
        return this.session;
    }

    @Override
    public String rawLine() {
        return this.line;
    }

    @Override
    public List<CliToken> lineTokens() {
        return this.tokens;
    }

    @Override
    public void complete(List<String> candidates) {
        String commonPrefix;
        String lastToken = this.tokens.get(this.tokens.size() - 1).value();
        if (StringUtils.isBlank(lastToken)) {
            lastToken = "";
        }
        if (candidates.size() > 1 && (commonPrefix = CompletionUtils.findLongestCommonPrefix(candidates)).length() > 0 && !commonPrefix.equals(lastToken) && commonPrefix.length() > lastToken.length()) {
            String strToComplete = commonPrefix.substring(lastToken.length());
            this.completion.complete(Helper.toCodePoints((String)strToComplete), false);
            return;
        }
        if (candidates.size() > 0) {
            LinkedList<int[]> suggestions = new LinkedList<int[]>();
            for (String candidate : candidates) {
                suggestions.add(Helper.toCodePoints((String)candidate));
            }
            this.completion.suggest(suggestions);
        } else {
            this.completion.end();
        }
    }

    @Override
    public void complete(String value, boolean terminal) {
        this.completion.complete(Helper.toCodePoints((String)value), terminal);
    }
}

