/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.klass100;

import com.taobao.arthas.core.command.express.ExpressException;
import com.taobao.arthas.core.command.express.ExpressFactory;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.arthas.core.util.SearchUtils;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.util.TypeRenderUtils;
import com.taobao.arthas.core.util.affect.RowAffect;
import com.taobao.arthas.core.util.matcher.Matcher;
import com.taobao.arthas.core.util.matcher.RegexMatcher;
import com.taobao.arthas.core.util.matcher.WildcardMatcher;
import com.taobao.arthas.core.view.ObjectView;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import com.taobao.middleware.logger.Logger;
import com.taobao.text.Color;
import com.taobao.text.Decoration;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.LabelElement;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Set;

@Name(value="getstatic")
@Summary(value="Show the static field of a class")
@Description(value="\nEXAMPLES:\n  getstatic getstatic demo.MathGame random\n  getstatic -c 39eb305e org.apache.log4j.LogManager DEFAULT_CONFIGURATION_FILE\n\nWIKI:\n  https://alibaba.github.io/arthas/getstatic")
public class GetStaticCommand
extends AnnotatedCommand {
    private static final Logger logger = LogUtil.getArthasLogger();
    private String classPattern;
    private String fieldPattern;
    private String express;
    private String hashCode = null;
    private boolean isRegEx = false;
    private int expand = 1;

    @Argument(argName="class-pattern", index=0)
    @Description(value="Class name pattern, use either '.' or '/' as separator")
    public void setClassPattern(String classPattern) {
        this.classPattern = classPattern;
    }

    @Argument(argName="field-pattern", index=1)
    @Description(value="Field name pattern")
    public void setFieldPattern(String fieldPattern) {
        this.fieldPattern = fieldPattern;
    }

    @Argument(argName="express", index=2, required=false)
    @Description(value="the content you want to watch, written by ognl")
    public void setExpress(String express) {
        this.express = express;
    }

    @Option(shortName="c", longName="classloader")
    @Description(value="The hash code of the special class's classLoader")
    public void setHashCode(String hashCode) {
        this.hashCode = hashCode;
    }

    @Option(shortName="E", longName="regex", flag=true)
    @Description(value="Enable regular expression to match (wildcard matching by default)")
    public void setRegEx(boolean regEx) {
        this.isRegEx = regEx;
    }

    @Option(shortName="x", longName="expand")
    @Description(value="Expand level of object (1 by default)")
    public void setExpand(Integer expand) {
        this.expand = expand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(CommandProcess process) {
        RowAffect affect = new RowAffect();
        Instrumentation inst = process.session().getInstrumentation();
        Set<Class<?>> matchedClasses = SearchUtils.searchClassOnly(inst, this.classPattern, this.isRegEx, this.hashCode);
        try {
            if (matchedClasses == null || matchedClasses.isEmpty()) {
                process.write("No class found for: " + this.classPattern + "\n");
            } else if (matchedClasses.size() > 1) {
                this.processMatches(process, matchedClasses);
            } else {
                this.processExactMatch(process, affect, inst, matchedClasses);
            }
        }
        finally {
            process.write(affect + "\n");
            process.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExactMatch(CommandProcess process, RowAffect affect, Instrumentation inst, Set<Class<?>> matchedClasses) {
        Matcher<String> fieldNameMatcher = this.fieldNameMatcher();
        Class<?> clazz = matchedClasses.iterator().next();
        boolean found = false;
        for (Field field : clazz.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !fieldNameMatcher.matching(field.getName())) continue;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                Object value = field.get(null);
                if (!StringUtils.isEmpty(this.express)) {
                    value = ExpressFactory.threadLocalExpress(value).get(this.express);
                }
                String result = StringUtils.objectToString(this.expand >= 0 ? new ObjectView(value, this.expand).draw() : value);
                process.write("field: " + field.getName() + "\n" + result + "\n");
                affect.rCnt(1);
            }
            catch (IllegalAccessException e) {
                logger.warn("getstatic: failed to get static value, class: " + clazz + ", field: " + field.getName(), (Throwable)e);
                process.write("Failed to get static, exception message: " + e.getMessage() + ", please check $HOME/logs/arthas/arthas.log for more details. \n");
            }
            catch (ExpressException e) {
                logger.warn("getstatic: failed to get express value, class: " + clazz + ", field: " + field.getName() + ", express: " + this.express, (Throwable)e);
                process.write("Failed to get static, exception message: " + e.getMessage() + ", please check $HOME/logs/arthas/arthas.log for more details. \n");
            }
            finally {
                found = true;
            }
        }
        if (!found) {
            process.write("getstatic: no matched static field was found\n");
        }
    }

    private void processMatches(CommandProcess process, Set<Class<?>> matchedClasses) {
        LabelElement usage = new LabelElement("getstatic -c <hashcode> " + this.classPattern + " " + this.fieldPattern).style(Decoration.bold.fg(Color.blue));
        process.write("\n Found more than one class for: " + this.classPattern + ", Please use " + RenderUtil.render((Element)usage, (int)process.width()));
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        table.row(new Element[]{new LabelElement("HASHCODE").style(Decoration.bold.bold()), new LabelElement("CLASSLOADER").style(Decoration.bold.bold())});
        for (Class<?> c : matchedClasses) {
            ClassLoader classLoader = c.getClassLoader();
            table.row(new Element[]{Element.label((String)Integer.toHexString(classLoader.hashCode())).style(Decoration.bold.fg(Color.red)), TypeRenderUtils.drawClassLoader(c)});
        }
        process.write(RenderUtil.render((Element)table, (int)process.width()) + "\n");
    }

    private Matcher<String> fieldNameMatcher() {
        return this.isRegEx ? new RegexMatcher(this.fieldPattern) : new WildcardMatcher(this.fieldPattern);
    }
}

