/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.basic1000;

import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Summary;
import com.taobao.text.Decoration;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.util.Properties;

@Name(value="sysprop")
@Summary(value="Display, and change the system properties.")
@Description(value="\nEXAMPLES:\n  sysprop\n  sysprop file.encoding\n  sysprop production.mode true\n\nWIKI:\n  https://alibaba.github.io/arthas/sysprop")
public class SystemPropertyCommand
extends AnnotatedCommand {
    private String propertyName;
    private String propertyValue;

    @Argument(index=0, argName="property-name", required=false)
    @Description(value="property name")
    public void setOptionName(String propertyName) {
        this.propertyName = propertyName;
    }

    @Argument(index=1, argName="property-value", required=false)
    @Description(value="property value")
    public void setOptionValue(String propertyValue) {
        this.propertyValue = propertyValue;
    }

    @Override
    public void process(CommandProcess process) {
        try {
            if (StringUtils.isBlank(this.propertyName) && StringUtils.isBlank(this.propertyValue)) {
                process.write(this.renderSystemProperties(System.getProperties(), process.width()));
            } else if (StringUtils.isBlank(this.propertyValue)) {
                String value = System.getProperty(this.propertyName);
                if (value == null) {
                    process.write("In order to change the system properties, you must specify the property value.\n");
                } else {
                    process.write(this.propertyName + "=" + value + "\n");
                }
            } else {
                System.setProperty(this.propertyName, this.propertyValue);
                process.write("Successfully changed the system property.\n");
                process.write(this.propertyName + "=" + System.getProperty(this.propertyName) + "\n");
            }
        }
        catch (Throwable t) {
            process.write("Error during setting system property: " + t.getMessage() + "\n");
        }
        finally {
            process.end();
        }
    }

    @Override
    public void complete(Completion completion) {
        CompletionUtils.complete(completion, System.getProperties().stringPropertyNames());
    }

    private String renderSystemProperties(Properties properties, int width) {
        TableElement table = new TableElement(new int[]{1, 4}).leftCellPadding(1).rightCellPadding(1);
        table.row(true, new Element[]{Element.label((String)"KEY").style(Decoration.bold.bold()), Element.label((String)"VALUE").style(Decoration.bold.bold())});
        for (String name : properties.stringPropertyNames()) {
            table.row(new String[]{name, properties.getProperty(name)});
        }
        return RenderUtil.render((Element)table, (int)width);
    }
}

